/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.PropertyHelper;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateHelper {
    private static Map<Class<? extends Entity>, Set<String>> directPropertiesCache = new HashMap<Class<? extends Entity>, Set<String>>();

    public static void addInElementsParameter(StringBuilder hql, Map<String, Object> namedParameters, String path, Entity value) {
        if (value != null && value.isPersistent()) {
            String parameterName = HibernateHelper.getParameterName(namedParameters, path);
            hql.append(" and :").append(parameterName).append(" in elements(").append(path).append(") ");
            namedParameters.put(parameterName, value);
        }
    }

    public static void addInParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, Collection<?> values) {
        if (values != null && !values.isEmpty()) {
            String parameterName = HibernateHelper.getParameterName(namedParameters, path);
            hql.append(" and ").append(path).append(" in (:").append(parameterName).append(") ");
            namedParameters.put(parameterName, values);
        }
    }

    public static void addInParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, Object ... values) {
        if (values != null && values.length > 0) {
            HibernateHelper.addInParameterToQuery(hql, namedParameters, path, Arrays.asList(values));
        }
    }

    public static void addLikeParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, String value) {
        HibernateHelper.doAddLike(hql, namedParameters, path, value, false);
    }

    public static void addParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, Object value) {
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, path, "=", value);
    }

    public static void addParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, QueryParameter parameter) {
        if (parameter != null) {
            HibernateHelper.addParameterToQueryOperator(hql, namedParameters, path, parameter.getOperator(), parameter.getValue());
        }
    }

    public static void addParameterToQueryOperator(StringBuilder hql, Map<String, Object> namedParameters, String path, String operator, Object value) {
        if (value != null && !"".equals(value)) {
            String parameterName = HibernateHelper.getParameterName(namedParameters, path);
            hql.append(" and ").append(path).append(" ").append(operator).append(" :").append(parameterName).append(" ");
            namedParameters.put(parameterName, value);
        }
    }

    public static void addPeriodParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, Period period) {
        HibernateHelper.addParameterToQuery(hql, namedParameters, path, HibernateHelper.getBeginParameter(period));
        HibernateHelper.addParameterToQuery(hql, namedParameters, path, HibernateHelper.getEndParameter(period));
    }

    public static void addRightLikeParameterToQuery(StringBuilder hql, Map<String, Object> namedParameters, String path, String value) {
        HibernateHelper.doAddLike(hql, namedParameters, path, value, true);
    }

    public static void appendJoinFetch(StringBuilder hql, Class<? extends Entity> entityType, String entityAlias, Collection<Relationship> fetch) {
        if (fetch != null) {
            Set<String> directRelationships = HibernateHelper.getDirectRelationshipProperties(entityType, fetch);
            for (String directRelationship : directRelationships) {
                hql.append(" left join fetch ").append(entityAlias).append(".").append(directRelationship).append(" ");
            }
        }
    }

    public static void appendOrder(StringBuilder hql, Collection<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            hql.append(" order by " + StringUtils.join(paths.iterator(), (String)","));
        }
    }

    public static void appendOrder(StringBuilder hql, String ... paths) {
        if (paths != null && paths.length > 0) {
            HibernateHelper.appendOrder(hql, Arrays.asList(paths));
        }
    }

    public static QueryParameter getBeginParameter(Period period) {
        if (period == null) {
            return null;
        }
        Calendar begin = period.getBegin();
        if (begin == null) {
            return null;
        }
        if (!period.isUseTime()) {
            begin = DateHelper.truncate(begin);
        }
        String operator = period.isInclusiveBegin() ? ">=" : ">";
        return new QueryParameter(begin, operator);
    }

    public static QueryParameter getEndParameter(Period period) {
        if (period == null) {
            return null;
        }
        Calendar end = period.getEnd();
        if (end == null) {
            return null;
        }
        if (!period.isUseTime()) {
            end = DateHelper.getDayEnd(end);
        }
        String operator = period.isInclusiveEnd() ? "<=" : "<";
        return new QueryParameter(end, operator);
    }

    public static StringBuilder getInitialQuery(Class<? extends Entity> entityType, String entityAlias) {
        return HibernateHelper.getInitialQuery(entityType, entityAlias, null);
    }

    public static StringBuilder getInitialQuery(Class<? extends Entity> entityType, String entityAlias, Collection<Relationship> fetch) {
        StringBuilder hql = new StringBuilder(" from ").append(entityType.getName()).append(" ").append(entityAlias).append(" ");
        HibernateHelper.appendJoinFetch(hql, entityType, entityAlias, fetch);
        hql.append(" where 1=1 ");
        return hql;
    }

    private static void doAddLike(StringBuilder hql, Map<String, Object> namedParameters, String path, String value, boolean rightOnly) {
        if ((value = StringUtils.trimToNull((String)value)) == null) {
            return;
        }
        if ((value = StringUtils.trimToNull((String)StringUtils.replace((String)value, (String)"%", (String)""))) == null) {
            return;
        }
        value = rightOnly ? value + "%" : "%" + value + "%";
        HibernateHelper.addParameterToQueryOperator(hql, namedParameters, path, "like", value);
    }

    private static Set<String> getDirectRelationshipProperties(Class<? extends Entity> entityType, Collection<Relationship> fetch) {
        Set<String> cachedDirectProperties = directPropertiesCache.get(entityType);
        if (cachedDirectProperties == null) {
            PropertyDescriptor[] propertyDescriptors;
            cachedDirectProperties = new HashSet<String>();
            for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(entityType)) {
                if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || !Entity.class.isAssignableFrom(descriptor.getPropertyType())) continue;
                cachedDirectProperties.add(descriptor.getName());
            }
            directPropertiesCache.put(entityType, cachedDirectProperties);
        }
        HashSet<String> propertiesToAddToFetch = new HashSet<String>();
        for (Relationship relationship : fetch) {
            String name = PropertyHelper.firstProperty(relationship.getName());
            if (!cachedDirectProperties.contains(name)) continue;
            propertiesToAddToFetch.add(name);
        }
        return propertiesToAddToFetch;
    }

    private static String getParameterName(Map<String, Object> namedParameters, String propertyName) {
        int counter = 1;
        StringBuilder sb = new StringBuilder(propertyName.length());
        int len = propertyName.length();
        for (int i = 0; i < len; ++i) {
            char c = propertyName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        String field = sb.toString();
        String parameterName = field.concat("_1");
        while (namedParameters.containsKey(parameterName)) {
            parameterName = field.concat("_").concat(String.valueOf(++counter));
        }
        return parameterName;
    }

    public static class QueryParameter {
        private final Object value;
        private final String operator;

        public QueryParameter(Object value, String operator) {
            this.value = value;
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

