/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.FetchingIteratorListImpl;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.ScrollableResultsIterator;
import nl.strohalm.cyclos.utils.query.PageImpl;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.lang.StringUtils;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.MapType;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateQueryHandler {
    private static Pattern FIRST_ALIAS = Pattern.compile("^ *(from +[^ ]+|select(?: +distinct)?) +([^ ]+).*");
    private static Pattern LEFT_JOIN_FETCH = Pattern.compile("\\^left\\s+join\\s+fetch(\\s+[\\w\\.]+)?(\\s*[\\w]+)?");
    private FetchDAO fetchDao;
    private HibernateTemplate hibernateTemplate;

    private static String stripFetch(String hql) {
        hql = hql.replaceAll("left join", "^left join");
        Matcher matcher = LEFT_JOIN_FETCH.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            boolean safeToRemove;
            String path = StringUtils.trimToEmpty((String)matcher.group(1));
            String alias = StringUtils.trimToEmpty((String)matcher.group(2));
            boolean nextIsLeft = "left".equalsIgnoreCase(alias);
            boolean bl = safeToRemove = alias.isEmpty() || nextIsLeft || "where".equalsIgnoreCase(alias) || "order".equalsIgnoreCase(alias) || "group".equalsIgnoreCase(alias);
            String replacement = safeToRemove ? (nextIsLeft ? "" : " " + alias) : " left join " + path + " " + alias;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll("\\^left join", "left join");
    }

    private static String transformToCount(String hql) {
        hql = HibernateQueryHandler.stripFetch(hql);
        int fromIndex = hql.indexOf("from ");
        int orderIndex = hql.indexOf("order by ");
        StringBuilder sb = new StringBuilder();
        boolean isDistinct = hql.indexOf(" distinct ") >= 0;
        Matcher matcher = FIRST_ALIAS.matcher(hql);
        if (matcher.matches()) {
            String firstAlias = matcher.group(2);
            sb.append("select count(").append(isDistinct ? " distinct " : "").append(firstAlias).append(".id) ");
        } else {
            sb.append("select count(*)");
        }
        if (orderIndex < 0) {
            sb.append(hql.substring(fromIndex));
        } else {
            sb.append(hql.substring(fromIndex, orderIndex));
        }
        return sb.toString();
    }

    public void applyPageParameters(PageParameters pageParameters, Query query) {
        Integer maxResults;
        Integer firstResult;
        Integer n = firstResult = pageParameters == null ? null : Integer.valueOf(pageParameters.getFirstResult());
        if (firstResult != null && firstResult >= 0) {
            query.setFirstResult(firstResult.intValue());
        }
        Integer n2 = maxResults = pageParameters == null ? null : Integer.valueOf(pageParameters.getMaxResults());
        if (maxResults != null && maxResults > 0) {
            query.setMaxResults(maxResults.intValue());
        }
    }

    public <E> List<E> applyResultParameters(QueryParameters.ResultType resultType, PageParameters pageParameters, Collection<E> records) {
        switch (resultType) {
            case LIST: 
            case ITERATOR: {
                int maxResults = pageParameters == null ? Integer.MAX_VALUE : pageParameters.getMaxResults();
                List<E> list = new ArrayList();
                if (maxResults > 0) {
                    int i = 0;
                    for (E item : records) {
                        list.add(item);
                        if (++i < maxResults) continue;
                        break;
                    }
                }
                if (resultType == QueryParameters.ResultType.ITERATOR) {
                    list = new IteratorListImpl(list.iterator());
                }
                return list;
            }
            case PAGE: {
                int currentPage = pageParameters == null ? 0 : pageParameters.getCurrentPage();
                int pageSize = pageParameters == null ? 15 : pageParameters.getPageSize();
                int firstIndex = currentPage * pageSize;
                int lastIndex = firstIndex + pageSize;
                ArrayList<E> pageElements = new ArrayList<E>(pageSize);
                int index = -1;
                for (E payment : records) {
                    if (++index < firstIndex) continue;
                    if (index > lastIndex) break;
                    pageElements.add(payment);
                }
                return new PageImpl(pageParameters, records.size(), pageElements);
            }
        }
        throw new IllegalStateException((Object)((Object)resultType) + "?");
    }

    public void copyProperties(Entity source, Entity dest) {
        if (source == null || dest == null) {
            return;
        }
        ClassMetadata metaData = this.getClassMetaData(source);
        Object[] values = metaData.getPropertyValues((Object)source, EntityMode.POJO);
        Type[] types = metaData.getPropertyTypes();
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (!(type instanceof CollectionType)) continue;
            values[i] = null;
        }
        metaData.setPropertyValues((Object)dest, values, EntityMode.POJO);
    }

    public <E> List<E> executeQuery(String cacheRegion, QueryParameters.ResultType resultType, String hql, Object namedParameters, PageParameters pageParameters, Relationship ... fetch) {
        switch (resultType) {
            case LIST: {
                return this.list(cacheRegion, hql, namedParameters, pageParameters, fetch);
            }
            case PAGE: {
                return this.page(cacheRegion, hql, namedParameters, pageParameters, fetch);
            }
            case ITERATOR: {
                return this.iterator(hql, namedParameters, pageParameters, fetch);
            }
        }
        throw new IllegalArgumentException("Unknown result type: " + (Object)((Object)resultType));
    }

    public ClassMetadata getClassMetaData(Entity entity) {
        return this.hibernateTemplate.getSessionFactory().getClassMetadata(EntityHelper.getRealClass(entity));
    }

    public FetchDAO getFetchDao() {
        return this.fetchDao;
    }

    public Object initialize(final Object object) {
        if (object instanceof HibernateProxy) {
            Entity entity = (Entity)object;
            entity = (Entity)this.getHibernateTemplate().load(EntityHelper.getRealClass(entity), (Serializable)entity.getId());
            if (entity instanceof HibernateProxy) {
                LazyInitializer lazyInitializer = ((HibernateProxy)entity).getHibernateLazyInitializer();
                lazyInitializer.initialize();
                return lazyInitializer.getImplementation();
            }
            return entity;
        }
        if (object instanceof PersistentCollection) {
            return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    String propertyName;
                    PersistentCollection persistentCollection = (PersistentCollection)object;
                    Entity owner = (Entity)persistentCollection.getOwner();
                    String role = persistentCollection.getRole();
                    if (owner == null || role == null) {
                        return persistentCollection;
                    }
                    Object currentCollection = PropertyHelper.get(owner = (Entity)session.get(EntityHelper.getRealClass(owner), (Serializable)owner.getId()), propertyName = PropertyHelper.lastProperty(role));
                    if (currentCollection instanceof PersistentCollection) {
                        Hibernate.initialize(currentCollection);
                    }
                    return currentCollection;
                }
            });
        }
        try {
            Hibernate.initialize((Object)object);
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException();
        }
        return object;
    }

    public Object initializeProperty(Object bean, String relationshipName) {
        String first = PropertyHelper.firstProperty(relationshipName);
        Object value = PropertyHelper.get(bean, first);
        value = this.initialize(value);
        PropertyHelper.set(bean, first, value);
        return value;
    }

    public void resolveReferences(Entity entity) {
        ClassMetadata meta = this.getClassMetaData(entity);
        String[] names = meta.getPropertyNames();
        Type[] types = meta.getPropertyTypes();
        for (int i = 0; i < types.length; ++i) {
            Collection current;
            Type type = types[i];
            String name = names[i];
            if (type instanceof EntityType) {
                Entity rel = (Entity)PropertyHelper.get(entity, name);
                if (!(rel instanceof EntityReference)) continue;
                rel = (Entity)this.getHibernateTemplate().load(EntityHelper.getRealClass(rel), (Serializable)rel.getId());
                PropertyHelper.set(entity, name, rel);
                continue;
            }
            if (!(type instanceof CollectionType) || type instanceof MapType || (current = (Collection)PropertyHelper.get(entity, name)) == null || current instanceof PersistentCollection) continue;
            boolean isEntityCollection = true;
            Collection resolved = (Collection)ClassHelper.instantiate(current.getClass());
            for (Object object : current) {
                if (object != null && !(object instanceof Entity)) {
                    isEntityCollection = false;
                    break;
                }
                Entity e = (Entity)object;
                if (object instanceof EntityReference) {
                    e = (Entity)this.getHibernateTemplate().load(EntityHelper.getRealClass(e), (Serializable)e.getId());
                }
                resolved.add(e);
            }
            if (!isEntityCollection) continue;
            PropertyHelper.set(entity, name, resolved);
        }
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setQueryParameters(Query query, Object parameters) {
        if (parameters != null) {
            if (parameters instanceof Map) {
                String[] paramNames;
                Map map = (Map)parameters;
                for (String param : paramNames = query.getNamedParameters()) {
                    Object value = map.get(param);
                    if (value instanceof Collection) {
                        ArrayList<Entity> values = new ArrayList<Entity>(((Collection)value).size());
                        for (Object object : (Collection)value) {
                            if (object instanceof EntityReference) {
                                values.add(this.fetchDao.fetch((Entity)object, new Relationship[0]));
                                continue;
                            }
                            values.add((Entity)object);
                        }
                        query.setParameterList(param, values);
                        continue;
                    }
                    if (value instanceof EntityReference) {
                        query.setParameter(param, (Object)this.fetchDao.fetch((Entity)value, new Relationship[0]));
                        continue;
                    }
                    query.setParameter(param, value);
                }
            } else {
                query.setProperties(parameters);
            }
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public <E> Iterator<E> simpleIterator(final String hql, final Object namedParameters, final PageParameters pageParameters) {
        Iterator iterator = (Iterator)this.getHibernateTemplate().execute(new HibernateCallback<Iterator<E>>(){

            public Iterator<E> doInHibernate(Session session) throws HibernateException {
                String strippedHql = HibernateQueryHandler.stripFetch(hql);
                Query query = session.createQuery(strippedHql);
                HibernateQueryHandler.this.applyPageParameters(pageParameters, query);
                HibernateQueryHandler.this.setQueryParameters(query, namedParameters);
                return new ScrollableResultsIterator(query, null);
            }
        });
        return iterator;
    }

    public <E> List<E> simpleList(final String cacheRegion, final String hql, final Object namedParameters, final PageParameters pageParameters, Relationship ... fetch) {
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback<List<E>>(){

            public List<E> doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(hql);
                HibernateQueryHandler.this.setQueryParameters(query, namedParameters);
                HibernateQueryHandler.this.applyPageParameters(pageParameters, query);
                if (cacheRegion != null) {
                    query.setCacheable(true);
                    query.setCacheRegion(cacheRegion);
                }
                return query.list();
            }
        });
        if (fetch != null && fetch.length > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                list.set(i, this.fetchDao.fetch(entity, fetch));
            }
        }
        return list;
    }

    private HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    private <E> List<E> iterator(String hql, Object namedParameters, PageParameters pageParameters, Relationship[] fetch) {
        Iterator<E> iterator = this.simpleIterator(hql, namedParameters, pageParameters);
        return new FetchingIteratorListImpl<E>(iterator, this.fetchDao, fetch);
    }

    private <E> List<E> list(String cacheRegion, String hql, Object namedParameters, PageParameters pageParameters, Relationship ... fetch) {
        return this.simpleList(cacheRegion, hql, namedParameters, pageParameters, fetch);
    }

    private <E> List<E> page(final String cacheRegion, final String hql, final Object namedParameters, PageParameters pageParameters, Relationship[] fetch) {
        Integer totalCount = (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(HibernateQueryHandler.transformToCount(hql.toString()));
                HibernateQueryHandler.this.setQueryParameters(query, namedParameters);
                HibernateQueryHandler.this.setCacheRegion(query, cacheRegion);
                return (Integer)query.uniqueResult();
            }
        });
        List<Object> list = pageParameters.getMaxResults() == 0 ? Collections.emptyList() : this.simpleList(cacheRegion, hql, namedParameters, pageParameters, fetch);
        return new PageImpl(pageParameters, totalCount, list);
    }

    private void setCacheRegion(Query query, String cacheRegion) {
        if (cacheRegion != null) {
            query.setCacheable(true);
            query.setCacheRegion(cacheRegion);
        }
    }
}

