/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.hibernate.AbstractEnumType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;

public class IntValuedEnumType<EnumType>
extends AbstractEnumType<EnumType> {
    private static final long serialVersionUID = 2442354783470853656L;
    private static final Log LOG = LogFactory.getLog(IntValuedEnumType.class);

    public static <T extends Enum<?>> Type getType(Class<T> enumClass) {
        return IntValuedEnumType.getType(IntValuedEnumType.class, enumClass);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        int value = rs.getInt(names[0]);
        if (!rs.wasNull()) {
            for (Object item : this.getEnumValues()) {
                IntValuedEnum intValuedEnum = (IntValuedEnum)item;
                if (value != intValuedEnum.getValue()) continue;
                return item;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning " + value + " as column " + names[0]));
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 4);
        } else {
            int val = value instanceof IntValuedEnum ? ((IntValuedEnum)value).getValue() : ((Number)value).intValue();
            st.setInt(index, val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding " + value + " to parameter: " + index));
        }
    }

    public int[] sqlTypes() {
        return new int[]{4};
    }
}

