/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.hibernate.AbstractEnumType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;

public class StringValuedEnumType<EnumType>
extends AbstractEnumType<EnumType> {
    private static final long serialVersionUID = 641293149816868313L;
    private static final Log LOG = LogFactory.getLog(StringValuedEnumType.class);

    public static <T extends Enum<?>> Type getType(Class<T> enumClass) {
        return StringValuedEnumType.getType(StringValuedEnumType.class, enumClass);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (!rs.wasNull()) {
            for (Object item : this.getEnumValues()) {
                StringValuedEnum stringValuedEnum = (StringValuedEnum)item;
                if (!value.equals(stringValuedEnum.getValue())) continue;
                return item;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning " + value + " as column " + names[0]));
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            String str = value instanceof StringValuedEnum ? ((StringValuedEnum)value).getValue() : value.toString();
            st.setString(index, str);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding " + value + " to parameter: " + index));
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }
}

