/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.hibernate.IntValuedEnumType;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public class TimePeriodType
implements CompositeUserType,
Serializable {
    private static final long serialVersionUID = -9056395153634021069L;
    private static final Log LOG = LogFactory.getLog(TimePeriodType.class);
    private static final Type[] TYPES = new Type[]{StandardBasicTypes.INTEGER, IntValuedEnumType.getType(TimePeriod.Field.class)};
    private static final int NUMBER = 0;
    private static final int FIELD = 1;
    private static final String[] NAMES = new String[]{"number", "field"};

    public Object assemble(Serializable value, SessionImplementor session, Object owner) throws HibernateException {
        return value == null ? null : ((TimePeriod)value).clone();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value == null ? null : ((TimePeriod)value).clone();
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : ((TimePeriod)value).clone();
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public String[] getPropertyNames() {
        return NAMES;
    }

    public Type[] getPropertyTypes() {
        return TYPES;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        TimePeriod period = (TimePeriod)component;
        switch (property) {
            case 0: {
                return period.getNumber();
            }
            case 1: {
                return period.getField();
            }
        }
        return null;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Integer number = rs.getInt(names[0]);
        if (rs.wasNull()) {
            number = null;
        }
        Integer field = rs.getInt(names[1]);
        if (rs.wasNull()) {
            field = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning " + number + " as column " + names[0]));
            LOG.debug((Object)("Returning " + field + " as column " + names[1]));
        }
        if (number == null || field == null) {
            return null;
        }
        TimePeriod timePeriod = new TimePeriod();
        timePeriod.setNumber(number);
        timePeriod.setField(TimePeriod.Field.findByCalendarField(field));
        return timePeriod;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        TimePeriod timePeriod = (TimePeriod)value;
        Integer number = null;
        TimePeriod.Field field = null;
        if (timePeriod == null || timePeriod.getField() == null) {
            st.setNull(index + 0, 4);
            st.setNull(index + 1, 4);
        } else {
            number = timePeriod.getNumber();
            field = timePeriod.getField();
            st.setInt(index + 0, number);
            st.setInt(index + 1, field.getCalendarValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding " + number + " to parameter: " + (index + 0)));
            LOG.debug((Object)("Binding " + field + " to parameter: " + (index + 1)));
        }
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original == null ? null : ((TimePeriod)original).clone();
    }

    public Class<?> returnedClass() {
        return TimePeriod.class;
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        TimePeriod timePeriod = (TimePeriod)component;
        switch (property) {
            case 0: {
                timePeriod.setNumber((Integer)value);
                break;
            }
            case 1: {
                timePeriod.setField((TimePeriod.Field)value);
            }
        }
    }
}

