/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import java.io.FileNotFoundException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Properties;
import nl.strohalm.cyclos.utils.instance.InstanceHandler;
import org.hibernate.util.StringHelper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HazelcastInstanceHandler
implements InstanceHandler,
InitializingBean,
DisposableBean {
    private Properties cyclosProperties;
    private HazelcastInstance hazelcastInstance;
    private Member member;

    public void afterPropertiesSet() throws Exception {
        String instanceName;
        URL xml = this.getClass().getResource("/hazelcast.xml");
        if (xml == null) {
            throw new FileNotFoundException("Configuration file hazelcast.xml was not found");
        }
        UrlXmlConfig config = new UrlXmlConfig(xml);
        String string = instanceName = this.cyclosProperties == null ? null : this.cyclosProperties.getProperty("cyclos.instanceHandler.instanceName");
        if (StringHelper.isEmpty((String)instanceName)) {
            instanceName = "cyclos";
        }
        config.setInstanceName(instanceName);
        this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        this.member = this.hazelcastInstance.getCluster().getLocalMember();
    }

    public void destroy() throws Exception {
        this.hazelcastInstance.getLifecycleService().shutdown();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    public String getId() {
        InetSocketAddress addr = this.member.getInetSocketAddress();
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.cyclosProperties = cyclosProperties;
    }
}

