/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.jfreeAsymmetric;

import java.util.List;
import nl.strohalm.cyclos.utils.jfreeAsymmetric.MeanWithAsymmetricErrorBar;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MeanAndStandardDeviation;
import org.jfree.data.statistics.StatisticalCategoryDataset;

public class AsymmetricStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo {
    private static final long serialVersionUID = -2787641442478041088L;
    private final KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private double minimumRangeValueIncStdDev;
    private double maximumRangeValue = Double.NaN;
    private double maximumRangeValueIncStdDev;

    public AsymmetricStatisticalCategoryDataset() {
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDev = Double.NaN;
    }

    public void add(double mean, double lower, double upper, Comparable rowKey, Comparable columnKey) {
        this.add(new Double(mean), new Double(lower), new Double(upper), rowKey, columnKey);
    }

    public void add(Number mean, Number lower, Number upper, Comparable rowKey, Comparable columnKey) {
        MeanWithAsymmetricErrorBar item = new MeanWithAsymmetricErrorBar(mean, lower, upper);
        this.data.addObject((Object)item, rowKey, columnKey);
        double m = 0.0;
        double l = 0.0;
        double u = 0.0;
        if (mean != null) {
            m = mean.doubleValue();
        }
        if (lower != null) {
            l = lower.doubleValue();
        }
        if (upper != null) {
            u = upper.doubleValue();
        }
        if (!Double.isNaN(m) && (Double.isNaN(this.maximumRangeValue) || m > this.maximumRangeValue)) {
            this.maximumRangeValue = m;
        }
        if (!Double.isNaN(u) && (Double.isNaN(this.maximumRangeValueIncStdDev) || u > this.maximumRangeValueIncStdDev)) {
            this.maximumRangeValueIncStdDev = u;
        }
        if (!Double.isNaN(m) && (Double.isNaN(this.minimumRangeValue) || m < this.minimumRangeValue)) {
            this.minimumRangeValue = m;
        }
        if (!Double.isNaN(l) && (Double.isNaN(this.minimumRangeValueIncStdDev) || l < this.minimumRangeValueIncStdDev)) {
            this.minimumRangeValueIncStdDev = l;
        }
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AsymmetricStatisticalCategoryDataset)) {
            return false;
        }
        AsymmetricStatisticalCategoryDataset that = (AsymmetricStatisticalCategoryDataset)((Object)obj);
        return this.data.equals((Object)that.data);
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public int getColumnIndex(Comparable key) {
        return this.data.getColumnIndex(key);
    }

    public Comparable getColumnKey(int column) {
        return this.data.getColumnKey(column);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public Number getLowerValue(int row, int column) {
        Number result = null;
        MeanWithAsymmetricErrorBar mwaeb = (MeanWithAsymmetricErrorBar)((Object)this.data.getObject(row, column));
        if (mwaeb != null) {
            result = mwaeb.getLower();
        }
        return result;
    }

    public Number getMeanValue(Comparable rowKey, Comparable columnKey) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(rowKey, columnKey);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    public Number getMeanValue(int row, int column) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(row, column);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    public Range getRangeBounds(boolean includeInterval) {
        Range result = null;
        if (includeInterval) {
            if (!Double.isNaN(this.minimumRangeValueIncStdDev) && !Double.isNaN(this.maximumRangeValueIncStdDev)) {
                result = new Range(this.minimumRangeValueIncStdDev, this.maximumRangeValueIncStdDev);
            }
        } else if (!Double.isNaN(this.minimumRangeValue) && !Double.isNaN(this.maximumRangeValue)) {
            result = new Range(this.minimumRangeValue, this.maximumRangeValue);
        }
        return result;
    }

    public double getRangeLowerBound(boolean includeInterval) {
        return this.minimumRangeValue;
    }

    public double getRangeUpperBound(boolean includeInterval) {
        return this.maximumRangeValue;
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getRowIndex(Comparable key) {
        return this.data.getRowIndex(key);
    }

    public Comparable getRowKey(int row) {
        return this.data.getRowKey(row);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public Number getStdDevValue(Comparable rowKey, Comparable columnKey) {
        throw new UnsupportedOperationException("getStdDevValue method is not supported. Use the getUpper and getLower methods in stead.");
    }

    public Number getStdDevValue(int row, int column) {
        throw new UnsupportedOperationException("getStdDevValue method is not supported. Use the getUpper and getLower methods in stead.");
    }

    public Number getUpperValue(int row, int column) {
        Number result = null;
        MeanWithAsymmetricErrorBar mwaeb = (MeanWithAsymmetricErrorBar)((Object)this.data.getObject(row, column));
        if (mwaeb != null) {
            result = mwaeb.getUpper();
        }
        return result;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getMeanValue(rowKey, columnKey);
    }

    public Number getValue(int row, int column) {
        return this.getMeanValue(row, column);
    }
}

