/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lock;

import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import nl.strohalm.cyclos.utils.lock.LockHandlerFactory;

public abstract class BaseLockHandlerFactory
implements LockHandlerFactory {
    private ApplicationServiceLocal applicationService;
    private static final LockHandler NO_OP_LOCK_HANDLER = new LockHandler(){

        @Override
        public void lock(Account ... accounts) throws LockingException {
        }

        @Override
        public void lockSmsStatus(Member member) throws LockingException {
        }

        @Override
        public void release() throws LockingException {
        }
    };

    @Override
    public final LockHandler getLockHandlerIfLockingAccounts() {
        return this.getLockHandlerIfLockingAtLeast(LockedAccountsOnPayments.ORIGIN);
    }

    @Override
    public final LockHandler getLockHandlerIfLockingAtLeast(LockedAccountsOnPayments minimumRequiredLocking) {
        if (this.applicationService.getLockedAccountsOnPayments().compareTo(minimumRequiredLocking) >= 0) {
            return this.getLockHandler();
        }
        return NO_OP_LOCK_HANDLER;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }
}

