/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lock;

import java.util.HashSet;
import java.util.Set;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.lock.UniqueObjectHandler;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;

public abstract class BaseUniqueObjectHandlerImpl
implements UniqueObjectHandler {
    private static ThreadLocal<Set<Pair<Object, Object>>> ACQUIRED = new ThreadLocal();

    @Override
    public boolean tryAcquire(final Pair<Object, Object> pair) {
        Set<Pair<Object, Object>> acquiredKeys = ACQUIRED.get();
        if (acquiredKeys != null && acquiredKeys.contains(pair)) {
            return true;
        }
        boolean acquired = this.getLocks().add(pair);
        if (acquired) {
            if (acquiredKeys == null) {
                acquiredKeys = new HashSet<Pair<Object, Object>>();
                ACQUIRED.set(acquiredKeys);
            }
            acquiredKeys.add(pair);
            CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                @Override
                protected void onTransactionEnd(boolean commit) {
                    BaseUniqueObjectHandlerImpl.this.release(pair);
                }
            });
        }
        return acquired;
    }

    protected abstract Set<Pair<Object, Object>> getLocks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(Pair<Object, Object> pair) {
        try {
            Set<Pair<Object, Object>> acquiredKeys = ACQUIRED.get();
            if (acquiredKeys != null) {
                acquiredKeys.remove(pair);
                if (acquiredKeys.isEmpty()) {
                    ACQUIRED.remove();
                }
            }
        }
        finally {
            this.getLocks().remove(pair);
        }
    }
}

