/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lock;

import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatusLock;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.ExceptionHelper;
import nl.strohalm.cyclos.utils.lock.BaseLockHandlerFactory;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DirectLockHandlerFactory
extends BaseLockHandlerFactory {
    private SessionFactory sessionFactory;
    private TransactionTemplate transactionTemplate;
    private final LockHandler lockHandler = new DirectLockHandler();

    @Override
    public LockHandler getLockHandler() {
        return this.lockHandler;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    private class DirectLockHandler
    implements LockHandler {
        private DirectLockHandler() {
        }

        @Override
        public void lock(Account ... accounts) throws LockingException {
            if (ArrayUtils.isEmpty((Object[])accounts)) {
                return;
            }
            Object[] ids = EntityHelper.toIds(accounts);
            Session session = SessionFactoryUtils.getSession((SessionFactory)DirectLockHandlerFactory.this.sessionFactory, (boolean)true);
            try {
                session.createQuery("select l.id from AccountLock l where l.id in (:ids)").setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE)).setParameterList("ids", ids).list();
            }
            catch (JDBCException e) {
                this.handleException(e);
            }
        }

        @Override
        public void lockSmsStatus(final Member member) throws LockingException {
            if (member == null) {
                return;
            }
            Session session = SessionFactoryUtils.getSession((SessionFactory)DirectLockHandlerFactory.this.sessionFactory, (boolean)true);
            try {
                Long id = (Long)session.createQuery("select m.id from MemberSmsStatusLock m where m.id = :id").setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE)).setParameter("id", (Object)member.getId()).uniqueResult();
                if (id == null) {
                    CurrentTransactionData.addTransactionRollbackListener(new TransactionRollbackListener(){

                        @Override
                        public void onTransactionRollback() {
                            DirectLockHandlerFactory.this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                                protected void doInTransactionWithoutResult(TransactionStatus status) {
                                    MemberSmsStatusLock lock = new MemberSmsStatusLock();
                                    lock.setId(member.getId());
                                    Session session = SessionFactoryUtils.getSession((SessionFactory)DirectLockHandlerFactory.this.sessionFactory, (boolean)true);
                                    session.save((Object)lock);
                                }
                            });
                        }
                    });
                    throw new LockingException("First time this member sms status. Please, retry.");
                }
            }
            catch (JDBCException e) {
                this.handleException(e);
            }
        }

        @Override
        public void release() {
        }

        private void handleException(JDBCException e) {
            if (ExceptionHelper.isLockingException(e)) {
                throw new LockingException(e);
            }
            throw e;
        }
    }
}

