/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lock;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.HazelcastHelper;
import nl.strohalm.cyclos.utils.lock.BaseLockHandlerFactory;
import nl.strohalm.cyclos.utils.lock.LockHandler;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HazelcastLockHandlerFactory
extends BaseLockHandlerFactory
implements InitializingBean,
ApplicationContextAware {
    public static final String TIMEOUT_SECONDS = "cyclos.lockHandler.timeoutSeconds";
    private Properties cyclosProperties;
    private int timeoutSeconds = 3;
    private HazelcastInstance hazelcastInstance;

    public void afterPropertiesSet() throws Exception {
        String secondsStr = StringUtils.trimToNull((String)this.cyclosProperties.getProperty(TIMEOUT_SECONDS));
        if (secondsStr != null) {
            try {
                this.timeoutSeconds = Integer.parseInt(secondsStr);
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid value for property cyclos.lockHandler.timeoutSeconds: " + secondsStr);
            }
        }
    }

    @Override
    public LockHandler getLockHandler() {
        return new HazelcastLockHandler();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.hazelcastInstance = HazelcastHelper.getHazelcastInstance(applicationContext);
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.cyclosProperties = cyclosProperties;
    }

    private class HazelcastLockHandler
    implements LockHandler {
        private final Map<LockKey, ILock> acquiredLocks = new HashMap<LockKey, ILock>();

        private HazelcastLockHandler() {
        }

        @Override
        public void lock(Account ... accounts) throws LockingException {
            Long[] ids;
            if (ArrayUtils.isEmpty((Object[])accounts)) {
                return;
            }
            for (Long id : ids = EntityHelper.toIds(accounts)) {
                this.acquire(new LockKey(LockType.ACCOUNT, id));
            }
        }

        @Override
        public void lockSmsStatus(Member member) throws LockingException {
            if (member == null) {
                return;
            }
            this.acquire(new LockKey(LockType.SMS_STATUS, member.getId()));
        }

        @Override
        public void release() {
            for (ILock lock : this.acquiredLocks.values()) {
                HazelcastHelper.release(lock);
            }
        }

        private void acquire(LockKey key) {
            if (this.acquiredLocks.containsKey(key)) {
                return;
            }
            ILock lock = HazelcastLockHandlerFactory.this.hazelcastInstance.getLock((Object)key);
            try {
                if (!lock.tryLock((long)HazelcastLockHandlerFactory.this.timeoutSeconds, TimeUnit.SECONDS)) {
                    throw new LockingException();
                }
                this.acquiredLocks.put(key, lock);
            }
            catch (InterruptedException e) {
                throw new LockingException(e);
            }
        }
    }

    public static enum LockType {
        ACCOUNT,
        SMS_STATUS;

    }

    public static class LockKey
    implements Serializable {
        private static final long serialVersionUID = 5893025909617161302L;
        private final LockType type;
        private final long id;

        public LockKey(LockType type, long id) {
            this.type = type;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LockKey)) {
                return false;
            }
            LockKey key = (LockKey)obj;
            return key.type == key.type && this.id == key.id;
        }

        public int hashCode() {
            return (int)((long)(13 * this.type.hashCode()) * this.id);
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.id;
        }
    }
}

