/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;

public class LogFormatter
extends Formatter
implements LocalSettingsChangeListener {
    public static final String SEPARATOR = "\t";
    private CalendarConverter dateTimeConverter;
    private SettingsServiceLocal settingsService;

    @Override
    public String format(LogRecord record) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(record.getMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDateTimeConverter().toString(cal));
        sb.append(SEPARATOR);
        sb.append(record.getMessage());
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            sb.append('\n');
            StringWriter w = new StringWriter();
            thrown.printStackTrace(new PrintWriter(w));
            sb.append(w);
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dateTimeConverter = null;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    private CalendarConverter getDateTimeConverter() {
        if (this.dateTimeConverter == null) {
            this.dateTimeConverter = this.settingsService == null ? new CalendarConverter("yyyy-MM-dd HH:mm:ss") : this.settingsService.getLocalSettings().getDateTimeConverter();
        }
        return this.dateTimeConverter;
    }
}

