/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.logging;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.entities.settings.events.LogSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LogSettingsEvent;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.FileUnits;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.logging.LogFormatter;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.RestLogDTO;
import nl.strohalm.cyclos.utils.logging.TraceLogDTO;
import nl.strohalm.cyclos.utils.logging.WebServiceLogDTO;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;

public class LoggingHandlerImpl
implements LoggingHandler,
LogSettingsChangeListener {
    private static final Log LOG = LogFactory.getLog(LoggingHandlerImpl.class);
    private Logger traceLogger;
    private boolean traceWritesOnly;
    private Logger webServiceLogger;
    private Logger transactionLogger;
    private Logger accountFeeLogger;
    private Logger scheduledTaskLogger;
    private Logger restLogger;
    private LogFormatter logFormatter;
    private SettingsServiceLocal settingsService;

    @Override
    public boolean isRestParametersLogEnabled() {
        Level detailed = LogSettings.WebServiceLevel.DETAILED.getLevel();
        return this.getRestLogger().isLoggable(detailed);
    }

    @Override
    public void logAccountFeeError(AccountFeeLog feeLog, Throwable error) {
        Level level;
        Logger logger = this.getAccountFeeLogger();
        if (logger.isLoggable(level = LogSettings.AccountFeeLevel.ERRORS.getLevel())) {
            try {
                logger.log(level, "Error on " + feeLog.getAccountFee().getName(), error);
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getAccountFeeFile());
            }
        }
    }

    @Override
    public void logAccountFeeFinished(AccountFeeLog feeLog) {
        Level level;
        Logger logger = this.getAccountFeeLogger();
        if (logger.isLoggable(level = LogSettings.AccountFeeLevel.STATUS.getLevel())) {
            try {
                logger.log(level, feeLog.getAccountFee().getName() + ": charging has finished");
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getAccountFeeFile());
            }
        }
    }

    @Override
    public void logAccountFeeInvoice(Invoice invoice) {
        Level level;
        Logger logger = this.getAccountFeeLogger();
        if (logger.isLoggable(level = LogSettings.AccountFeeLevel.DETAILED.getLevel())) {
            UnitsConverter unitsConverter = this.settingsService.getLocalSettings().getUnitsConverter(invoice.getTransferType().getFrom().getCurrency().getPattern());
            String message = "Sent invoice of %s from %s";
            Object[] params = new Object[]{unitsConverter.toString(invoice.getAmount()), invoice.getToMember().getUsername()};
            try {
                logger.log(level, String.format("Sent invoice of %s from %s", params));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getAccountFeeFile());
            }
        }
    }

    @Override
    public void logAccountFeePayment(Transfer transfer) {
        Level level;
        Logger logger = this.getAccountFeeLogger();
        if (logger.isLoggable(level = LogSettings.AccountFeeLevel.DETAILED.getLevel())) {
            Object[] params;
            String message;
            AccountFeeLog feeLog = transfer.getAccountFeeLog();
            AccountFee fee = feeLog.getAccountFee();
            UnitsConverter unitsConverter = this.settingsService.getLocalSettings().getUnitsConverter(transfer.getFrom().getType().getCurrency().getPattern());
            if (fee.getPaymentDirection() == AccountFee.PaymentDirection.TO_SYSTEM) {
                message = "Charged %s from %s";
                params = new Object[]{unitsConverter.toString(transfer.getAmount()), transfer.getFrom().getOwnerName()};
            } else {
                message = "Paid %s to %s";
                params = new Object[]{unitsConverter.toString(transfer.getAmount()), transfer.getTo().getOwnerName()};
            }
            try {
                logger.log(level, String.format(message, params));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getAccountFeeFile());
            }
        }
    }

    @Override
    public void logAccountFeeStarted(AccountFeeLog feeLog) {
        Level level;
        Logger logger = this.getAccountFeeLogger();
        if (logger.isLoggable(level = LogSettings.AccountFeeLevel.STATUS.getLevel())) {
            try {
                logger.log(level, feeLog.getAccountFee().getName() + ": charging has started");
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getAccountFeeFile());
            }
        }
    }

    @Override
    public void logScheduledTaskError(String taskName, Calendar hour, Exception error) {
        Level level;
        Logger logger = this.getScheduledTaskLogger();
        if (logger.isLoggable(level = LogSettings.ScheduledTaskLevel.ERRORS.getLevel())) {
            try {
                logger.log(level, "Exception on scheduled task: " + taskName + " for hour " + FormatObject.formatObject(hour), error);
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getScheduledTaskFile());
            }
        }
    }

    @Override
    public void logScheduledTaskTrace(String taskName, Calendar hour, long timeTaken) {
        Level level;
        Logger logger = this.getScheduledTaskLogger();
        if (logger.isLoggable(level = LogSettings.ScheduledTaskLevel.DETAILED.getLevel())) {
            MathContext mathContext = this.settingsService.getLocalSettings().getMathContext();
            String formattedTime = this.settingsService.getLocalSettings().getNumberConverter().toString(new BigDecimal(timeTaken).divide(new BigDecimal(1000), mathContext));
            try {
                logger.log(level, String.format("Scheduled task '%s' for hour %s ran on %s seconds", taskName, FormatObject.formatObject(hour), formattedTime));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getScheduledTaskFile());
            }
        }
    }

    @Override
    public void logSchedulingTrace(Calendar hour, long timeTaken) {
        Level level;
        Logger logger = this.getScheduledTaskLogger();
        if (logger.isLoggable(level = LogSettings.ScheduledTaskLevel.INFO.getLevel())) {
            MathContext mathContext = this.settingsService.getLocalSettings().getMathContext();
            String formattedTime = this.settingsService.getLocalSettings().getNumberConverter().toString(new BigDecimal(timeTaken).divide(new BigDecimal(1000), mathContext));
            try {
                logger.log(level, String.format("Scheduled tasks for hour %s ran on %s seconds", FormatObject.formatObject(hour), formattedTime));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getScheduledTaskFile());
            }
        }
    }

    @Override
    public void logTransfer(Transfer transfer) {
        boolean willLog;
        Logger logger = this.getTransactionLogger();
        Level detailed = LogSettings.TransactionLevel.DETAILED.getLevel();
        Level normal = LogSettings.TransactionLevel.NORMAL.getLevel();
        boolean detailedLoggable = logger.isLoggable(detailed);
        boolean normalLoggable = logger.isLoggable(normal);
        boolean bl = willLog = detailedLoggable || normalLoggable;
        if (willLog) {
            Object[] args;
            String message;
            Level level;
            String loggedUser;
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            UnitsConverter unitsConverter = localSettings.getUnitsConverter(transfer.getFrom().getType().getCurrency().getPattern());
            String string = loggedUser = LoggedUser.hasUser() ? ((User)LoggedUser.user()).getUsername() : "<no logged user>";
            if (detailedLoggable) {
                TransferType type = transfer.getType();
                level = detailed;
                message = "logged user: %s, id: %s, date: %s, type: %s (%s), amount: %s, from: %s, to: %s, by: %s, tx#: %s, description: %s";
                Element by = transfer.getBy();
                args = new Object[]{loggedUser, transfer.getId(), localSettings.getDateTimeConverter().toString(transfer.getDate()), type.getId(), type.getName(), unitsConverter.toString(transfer.getAmount()), transfer.getFrom().getOwnerName(), transfer.getTo().getOwnerName(), by == null ? "<null>" : by.getUsername(), StringUtils.defaultIfEmpty((String)transfer.getTransactionNumber(), (String)"<null>"), StringUtils.replace((String)transfer.getDescription(), (String)"\n", (String)"\\n")};
            } else {
                level = normal;
                message = "logged user: %s, id: %s, amount: %s, from: %s, to: %s";
                args = new Object[]{loggedUser, transfer.getId(), unitsConverter.toString(transfer.getAmount()), transfer.getFrom().getOwnerName(), transfer.getTo().getOwnerName()};
            }
            try {
                logger.log(level, String.format(message, args));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getTransactionFile());
            }
        }
    }

    @Override
    public synchronized void onLogSettingsUpdate(LogSettingsEvent event) {
        this.close(this.traceLogger);
        this.traceLogger = null;
        this.close(this.webServiceLogger);
        this.webServiceLogger = null;
        this.close(this.transactionLogger);
        this.transactionLogger = null;
        this.close(this.accountFeeLogger);
        this.accountFeeLogger = null;
        this.close(this.scheduledTaskLogger);
        this.scheduledTaskLogger = null;
    }

    public void setLogFormatter(LogFormatter logFormatter) {
        this.logFormatter = logFormatter;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal service) {
        this.settingsService = service;
        service.addListener(this);
    }

    @Override
    public void trace(TraceLogDTO params) {
        Level logLevel;
        boolean detailedLoggable;
        Logger logger = this.getTraceLogger();
        boolean isError = params.getError() != null;
        Level detailed = LogSettings.TraceLevel.DETAILED.getLevel();
        boolean logParameters = detailedLoggable = logger.isLoggable(detailed);
        if (isError) {
            Level error = LogSettings.TraceLevel.ERRORS.getLevel();
            boolean errorLoggable = logger.isLoggable(error);
            logLevel = errorLoggable ? error : null;
        } else {
            if (this.traceWritesOnly && !params.isHasDatabaseWrites()) {
                return;
            }
            Level normal = LogSettings.TraceLevel.SIMPLE.getLevel();
            boolean normalLoggable = logger.isLoggable(normal);
            Level level = detailedLoggable ? detailed : (logLevel = normalLoggable ? normal : null);
        }
        if (logLevel != null) {
            String message = this.buildActionString(params, logParameters);
            try {
                logger.log(logLevel, message, params.getError());
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getTraceFile());
            }
        }
    }

    @Override
    public void traceLogin(TraceLogDTO params) {
        params.setRequestMethod("LOGIN");
        this.traceLoginLogout(params);
    }

    @Override
    public void traceLogout(TraceLogDTO params) {
        params.setRequestMethod("LOGOUT");
        this.traceLoginLogout(params);
    }

    @Override
    public void traceRest(RestLogDTO params) {
        boolean isError;
        Logger logger = this.getRestLogger();
        WebServiceLogPrepareResult result = this.prepareWebService(logger, isError = params.getError() != null);
        if (result.logLevel != null) {
            String message = this.buildRestString(params, result.logParameters);
            try {
                logger.log(result.logLevel, message, params.getError());
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getWebServiceFile());
            }
        }
    }

    @Override
    public void traceWebService(WebServiceLogDTO params) {
        boolean isError;
        Logger logger = this.getWebServiceLogger();
        WebServiceLogPrepareResult result = this.prepareWebService(logger, isError = params.getError() != null || StringUtils.isNotEmpty((String)params.getErrorMessage()));
        if (result.logLevel != null) {
            String message = this.buildWebServiceString(params, result.logParameters);
            try {
                logger.log(result.logLevel, message, params.getError());
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getWebServiceFile());
            }
        }
    }

    private void appendPropertyValues(StringBuilder sb, Object bean) {
        if (bean == null) {
            sb.append("<null>");
            return;
        }
        if (bean instanceof String) {
            sb.append(bean);
            return;
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(bean);
        boolean first = true;
        for (PropertyDescriptor desc : bw.getPropertyDescriptors()) {
            if (desc.getWriteMethod() == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String name = desc.getName();
            sb.append(name).append('=');
            Object value = bw.getPropertyValue(name);
            this.appendValue(sb, FormatObject.maskIfNeeded(name, value));
        }
    }

    private void appendValue(StringBuilder sb, String value) {
        if (value == null) {
            return;
        }
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private String buildActionString(TraceLogDTO params, boolean logParameters) {
        String remoteAddress = params.getRemoteAddress();
        User user = params.getUser();
        String requestMethod = params.getRequestMethod();
        String sessionId = params.getSessionId();
        String path = params.getPath();
        Map<String, String[]> parameters = params.getParameters();
        StringBuilder sb = new StringBuilder();
        this.appendValue(sb, remoteAddress);
        sb.append("\t");
        this.appendValue(sb, sessionId);
        sb.append("\t");
        sb.append(user == null ? "<unknown user>" : user.getUsername()).append("\t");
        sb.append(StringUtils.rightPad((String)(requestMethod == null ? "" : requestMethod), (int)6, (char)' ')).append("\t");
        if (path != null) {
            sb.append(path);
            if (logParameters) {
                sb.append("\t");
                boolean first = true;
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    String name = entry.getKey();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    Object[] value = entry.getValue();
                    if (ArrayUtils.isEmpty((Object[])value)) continue;
                    sb.append(name).append('=');
                    if (FormatObject.shouldMask(name)) {
                        sb.append("***");
                        continue;
                    }
                    if (value.length == 1) {
                        this.appendValue(sb, (String)value[0]);
                        continue;
                    }
                    sb.append('[');
                    for (int i = 0; i < value.length; ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        this.appendValue(sb, (String)value[i]);
                    }
                    sb.append(']');
                }
            }
        }
        return sb.toString();
    }

    private String buildRestString(RestLogDTO params, boolean logParameters) {
        StringBuilder sb = new StringBuilder();
        this.appendValue(sb, params.getRemoteAddress());
        sb.append("\t");
        this.appendValue(sb, params.getMember() == null ? "" : params.getMember().getUsername());
        sb.append("\t");
        this.appendValue(sb, params.getMethod() == null ? "" : params.getMethod());
        sb.append("\t");
        this.appendValue(sb, params.getUri() == null ? "" : params.getUri());
        if (logParameters) {
            sb.append("\t");
            this.appendPropertyValues(sb, params.getQueryString() == null ? "" : params.getQueryString());
            sb.append("\t");
            this.appendPropertyValues(sb, params.getRequestBody() == null ? "" : params.getRequestBody());
        }
        return sb.toString();
    }

    private String buildWebServiceString(WebServiceLogDTO params, boolean logParameters) {
        String remoteAddress = params.getRemoteAddress();
        Pos pos = params.getPos();
        ServiceClient serviceClient = params.getServiceClient();
        String message = params.getMessage();
        String serviceName = params.getServiceName();
        String methodName = params.getMethodName();
        String errorMessage = params.getErrorMessage();
        Object parameter = params.getParameter();
        StringBuilder sb = new StringBuilder();
        this.appendValue(sb, remoteAddress);
        sb.append("\t");
        String clientDescription = "";
        Member member = null;
        String channel = null;
        if (pos != null) {
            clientDescription = "POS<" + pos.getPosId() + ">";
            try {
                member = pos.getMemberPos().getMember();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            channel = "pos";
        } else if (serviceClient != null) {
            clientDescription = "CLIENT<" + serviceClient.getName() + ">";
            member = serviceClient.getMember();
            try {
                channel = serviceClient.getChannel().getInternalName();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        sb.append(channel == null ? "" : channel).append("\t");
        sb.append(clientDescription).append("\t");
        sb.append(member == null ? "" : member.getUsername()).append("\t");
        sb.append(message != null ? message : (errorMessage != null ? errorMessage : "")).append("\t");
        if (serviceName != null && methodName != null) {
            sb.append(serviceName).append('.').append(methodName);
            if (logParameters) {
                sb.append("\t");
                this.appendPropertyValues(sb, parameter);
            }
        }
        return sb.toString();
    }

    private void close(Logger logger) {
        if (logger == null) {
            return;
        }
        for (Handler handler : logger.getHandlers()) {
            try {
                handler.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while closing log handler - Ignoring", (Throwable)e);
            }
        }
    }

    private Logger getAccountFeeLogger() {
        if (this.accountFeeLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.accountFeeLogger = this.init(logSettings.getAccountFeeLevel().getLevel(), logSettings.getAccountFeeFile());
        }
        return this.accountFeeLogger;
    }

    private Logger getRestLogger() {
        if (this.restLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.restLogger = this.init(logSettings.getRestLevel().getLevel(), logSettings.getRestFile());
        }
        return this.restLogger;
    }

    private Logger getScheduledTaskLogger() {
        if (this.scheduledTaskLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.scheduledTaskLogger = this.init(logSettings.getScheduledTaskLevel().getLevel(), logSettings.getScheduledTaskFile());
        }
        return this.scheduledTaskLogger;
    }

    private Logger getTraceLogger() {
        if (this.traceLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.traceLogger = this.init(logSettings.getTraceLevel().getLevel(), logSettings.getTraceFile());
            this.traceWritesOnly = logSettings.isTraceWritesOnly();
        }
        return this.traceLogger;
    }

    private Logger getTransactionLogger() {
        if (this.transactionLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.transactionLogger = this.init(logSettings.getTransactionLevel().getLevel(), logSettings.getTransactionFile());
        }
        return this.transactionLogger;
    }

    private Logger getWebServiceLogger() {
        if (this.webServiceLogger == null) {
            LogSettings logSettings = this.settingsService.getLogSettings();
            this.webServiceLogger = this.init(logSettings.getWebServiceLevel().getLevel(), logSettings.getWebServiceFile());
        }
        return this.webServiceLogger;
    }

    private Logger init(Level level, String file) {
        LogSettings logSettings = this.settingsService.getLogSettings();
        Logger logger = Logger.getAnonymousLogger();
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        try {
            FileUnits units = logSettings.getMaxLengthPerFileUnits();
            FileHandler fileHandler = new FileHandler(file, units.calculate(logSettings.getMaxLengthPerFile()), logSettings.getMaxFilesPerLog(), true);
            fileHandler.setFormatter(this.logFormatter);
            fileHandler.setEncoding(this.settingsService.getLocalSettings().getCharset());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(this.logFormatter);
            try {
                consoleHandler.setEncoding(this.settingsService.getLocalSettings().getCharset());
            }
            catch (Exception e1) {
                // empty catch block
            }
            logger.addHandler(consoleHandler);
            logger.log(Level.WARNING, "Unable to create logger for file " + file);
        }
        return logger;
    }

    private WebServiceLogPrepareResult prepareWebService(Logger logger, boolean isError) {
        Level logLevel;
        boolean detailedLoggable;
        Level detailed = LogSettings.WebServiceLevel.DETAILED.getLevel();
        boolean logParameters = detailedLoggable = logger.isLoggable(detailed);
        if (isError) {
            Level error = LogSettings.WebServiceLevel.ERRORS.getLevel();
            boolean errorLoggable = logger.isLoggable(error);
            logLevel = errorLoggable ? error : null;
        } else {
            Level normal = LogSettings.WebServiceLevel.SIMPLE.getLevel();
            boolean normalLoggable = logger.isLoggable(normal);
            logLevel = detailedLoggable ? detailed : (normalLoggable ? normal : null);
        }
        return new WebServiceLogPrepareResult(logLevel, logParameters);
    }

    private void traceLoginLogout(TraceLogDTO params) {
        Level level;
        Logger logger = this.getTraceLogger();
        if (logger.isLoggable(level = LogSettings.TraceLevel.SIMPLE.getLevel())) {
            try {
                logger.log(level, this.buildActionString(params, false));
            }
            catch (Exception e) {
                System.out.println("Error generating log on " + this.settingsService.getLogSettings().getTraceFile());
            }
        }
    }

    private static class WebServiceLogPrepareResult {
        private final Level logLevel;
        private final boolean logParameters;

        public WebServiceLogPrepareResult(Level logLevel, boolean logParameters) {
            this.logLevel = logLevel;
            this.logParameters = logParameters;
        }
    }
}

