/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.utils.lucene.DocumentBuilder;
import nl.strohalm.cyclos.utils.lucene.DocumentMapper;
import org.apache.lucene.document.Document;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class AbstractDocumentMapper<E extends Entity>
implements DocumentMapper {
    protected SessionFactory sessionFactory;
    protected FetchDAO fetchDao;

    @Override
    public final Document map(Indexable indexable) {
        Entity entity = (Entity)((Object)indexable);
        DocumentBuilder document = this.newDocumentBuilder();
        document.add("id", entity);
        this.process(document, entity);
        return document.getDocument();
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    protected DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.fetchDao);
    }

    protected abstract void process(DocumentBuilder var1, E var2);
}

