/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.utils.lucene.LuceneQueryHandler;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class DocsIterator<E extends Entity>
implements Closeable,
Iterator<E> {
    private final LuceneQueryHandler luceneQueryHandler;
    private final Class<E> entityType;
    private final IndexReader reader;
    private final TopDocs topDocs;
    private final Relationship[] fetch;
    private int index;
    private E entity;

    public DocsIterator(LuceneQueryHandler luceneQueryHandler, Class<E> entityType, IndexReader reader, TopDocs topDocs, int firstResult, Relationship[] fetch) {
        this.luceneQueryHandler = luceneQueryHandler;
        this.entityType = entityType;
        this.reader = reader;
        this.topDocs = topDocs;
        this.fetch = fetch;
        this.index = firstResult;
        this.entity = this.getNextEntity();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() {
        return this.entity != null;
    }

    @Override
    public E next() {
        if (this.entity == null) {
            throw new NoSuchElementException();
        }
        E result = this.entity;
        this.entity = this.getNextEntity();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private E getNextEntity() {
        E entity = null;
        try {
            ScoreDoc scoreDoc = this.topDocs.scoreDocs[this.index++];
            entity = this.luceneQueryHandler.toEntity(this.reader, scoreDoc.doc, this.entityType, this.fetch);
            if (entity == null) {
                entity = this.getNextEntity();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            entity = null;
        }
        return entity;
    }
}

