/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.lucene.LuceneFormatter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class DocumentBuilder {
    private final Document document = new Document();
    private final FetchDAO fetchDao;

    public DocumentBuilder(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public DocumentBuilder add(String name, BigDecimal value) {
        return this.add(name, LuceneFormatter.format(value), false);
    }

    public DocumentBuilder add(String name, boolean value) {
        return this.add(name, String.valueOf(value), false);
    }

    public DocumentBuilder add(String name, Calendar value) {
        return this.add(name, LuceneFormatter.format(value), false);
    }

    public DocumentBuilder add(String name, Collection<? extends CustomFieldValue> fieldValues) {
        if (CollectionUtils.isNotEmpty(fieldValues)) {
            for (CustomFieldValue customFieldValue : fieldValues) {
                boolean isMember;
                CustomFieldValue customFieldValue2 = this.fetchDao.fetch(customFieldValue, CustomFieldValue.Relationships.FIELD);
                String stringValue = customFieldValue2.getStringValue();
                CustomFieldPossibleValue possibleValue = customFieldValue2.getPossibleValue();
                Member memberValue = customFieldValue2.getMemberValue();
                if (StringUtils.isEmpty((String)stringValue) && possibleValue == null && memberValue == null) continue;
                CustomField field = customFieldValue2.getField();
                CustomField.Type type = field.getType();
                boolean isString = type == CustomField.Type.STRING || type == CustomField.Type.URL;
                boolean isEnumerated = type == CustomField.Type.ENUMERATED;
                boolean bl = isMember = type == CustomField.Type.MEMBER;
                if (this.includeInKeywordsSearch(name, customFieldValue2)) {
                    if (isString && StringUtils.isNotEmpty((String)stringValue)) {
                        boolean analyzed = org.hibernate.util.StringHelper.isEmpty((String)field.getPattern());
                        stringValue = StringHelper.removeMarkupTagsAndUnescapeEntities(stringValue);
                        this.add(name, stringValue, analyzed);
                    } else if (isEnumerated && possibleValue != null) {
                        this.add(name, possibleValue.getValue());
                    } else if (isMember && memberValue != null) {
                        this.add(name, memberValue.getName());
                        this.add(name, memberValue.getUsername());
                    }
                }
                if (!this.includeInSpecificFiltering(name, customFieldValue2)) continue;
                String filterName = name + "." + customFieldValue2.getField().getId();
                if (isString) {
                    boolean analyzed = org.hibernate.util.StringHelper.isEmpty((String)field.getPattern());
                    stringValue = StringHelper.removeMarkupTagsAndUnescapeEntities(stringValue);
                    this.add(filterName, stringValue, analyzed);
                    continue;
                }
                if (isEnumerated) {
                    this.add(filterName, possibleValue);
                    continue;
                }
                if (isMember) {
                    this.add(filterName, memberValue);
                    continue;
                }
                this.add(filterName, stringValue, false);
            }
        }
        return this;
    }

    public DocumentBuilder add(String name, Entity entity) {
        if (entity != null) {
            this.add(name, IdConverter.instance().toString(entity.getId()), false);
        }
        return this;
    }

    public DocumentBuilder add(String name, Enum<?> enumerated) {
        if (enumerated != null) {
            this.add(name, enumerated.name(), false);
        }
        return this;
    }

    public DocumentBuilder add(String name, String value) {
        return this.add(name, value, true);
    }

    public DocumentBuilder add(String name, String value, boolean analyzed) {
        if (StringUtils.isNotEmpty((String)value)) {
            Field field = new Field(name, value, Field.Store.YES, analyzed ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED);
            this.document.add((Fieldable)field);
        }
        return this;
    }

    public Document getDocument() {
        return this.document;
    }

    protected boolean includeInKeywordsSearch(String name, CustomFieldValue fieldValue) {
        return true;
    }

    protected boolean includeInSpecificFiltering(String name, CustomFieldValue fieldValue) {
        return true;
    }
}

