/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.lucene.LuceneFormatter;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.ChainedFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermsFilter;

public class Filters
extends Filter
implements Cloneable {
    private static final long serialVersionUID = -5904251497348657910L;
    private final List<Filter> filters = new ArrayList<Filter>();

    public static Filter and(Filter ... filters) {
        return Filters.chain(1, filters);
    }

    public static Filter andNot(Filter ... filters) {
        return Filters.chain(2, filters);
    }

    public static Filter fieldQuery(Analyzer analyzer, String field, String query) {
        if (StringUtils.isEmpty((String)query)) {
            return null;
        }
        QueryParser parser = new QueryParser(LuceneUtils.LUCENE_VERSION, field, analyzer);
        try {
            Query q = parser.parse(query);
            return new QueryWrapperFilter(q);
        }
        catch (ParseException e) {
            throw new QueryParseException();
        }
    }

    public static Query filter(Query query, Filter filter) {
        return new FilteredQuery(query, (Filter)new CachingWrapperFilter(filter));
    }

    public static Filter or(Filter ... filters) {
        return Filters.chain(0, filters);
    }

    public static TermRangeFilter range(String field, Calendar min, Calendar max) {
        return Filters.range(field, min, max, true, true);
    }

    public static TermRangeFilter range(String field, Calendar min, Calendar max, boolean includeMin, boolean includeMax) {
        if (min == null && max == null) {
            return null;
        }
        String minStr = min == null ? LuceneFormatter.MIN_DATE : LuceneFormatter.format(min);
        String maxStr = max == null ? LuceneFormatter.MAX_DATE : LuceneFormatter.format(max);
        return new TermRangeFilter(field, minStr, maxStr, includeMin, includeMax);
    }

    public static TermRangeFilter range(String field, Number min, Number max) {
        return Filters.range(field, min, max, true, true);
    }

    public static TermRangeFilter range(String field, Number min, Number max, boolean includeMin, boolean includeMax) {
        if (min == null && max == null) {
            return null;
        }
        String minStr = min == null ? LuceneFormatter.MIN_DECIMAL : LuceneFormatter.format(min);
        String maxStr = max == null ? LuceneFormatter.MAX_DECIMAL : LuceneFormatter.format(max);
        return new TermRangeFilter(field, minStr, maxStr, includeMin, includeMax);
    }

    public static TermRangeFilter range(String field, String min, String max) {
        return Filters.range(field, min, max, true, true);
    }

    public static TermRangeFilter range(String field, String min, String max, boolean includeMin, boolean includeMax) {
        if (StringUtils.isEmpty((String)min) || StringUtils.isEmpty((String)max)) {
            return null;
        }
        return new TermRangeFilter(field, min, max, includeMin, includeMax);
    }

    public static Filter terms(String field, Collection<?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        TermsFilter filter = new TermsFilter();
        int count = 0;
        for (Object object : values) {
            String term = object == null ? null : StringUtils.trimToNull((String)("" + object));
            if (term == null) continue;
            filter.addTerm(new Term(field, term));
            ++count;
        }
        return count == 0 ? null : filter;
    }

    public static Filter terms(String field, Object ... values) {
        return values == null ? null : Filters.terms(field, Arrays.asList(values));
    }

    private static Filter chain(int logic, Filter ... filters) {
        if (ArrayUtils.isEmpty((Object[])(filters = Filters.normalize(filters)))) {
            return null;
        }
        return new ChainedFilter(filters, logic);
    }

    private static Filter[] normalize(Filter[] filters) {
        if (ArrayUtils.isEmpty((Object[])filters)) {
            return null;
        }
        ArrayList<Filter> list = new ArrayList<Filter>(filters.length);
        for (Filter filter : filters) {
            if (filter == null) continue;
            list.add(filter);
        }
        return list.isEmpty() ? null : list.toArray(new Filter[list.size()]);
    }

    public void add(Filter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFieldQuery(Analyzer analyzer, String field, String query) {
        this.add(Filters.fieldQuery(analyzer, field, query));
    }

    public void addPeriod(String field, Period period) {
        if (period != null) {
            this.addRange(field, period.getBegin(), DateHelper.truncateNextDay(period.getEnd()), true, false);
        }
    }

    public void addRange(String field, Calendar min, Calendar max) {
        this.addRange(field, min, max, true, true);
    }

    public void addRange(String field, Calendar min, Calendar max, boolean includeMin, boolean includeMax) {
        this.add((Filter)Filters.range(field, min, max, includeMin, includeMax));
    }

    public void addRange(String field, Number min, Number max) {
        this.addRange(field, min, max, true, true);
    }

    public void addRange(String field, Number min, Number max, boolean includeMin, boolean includeMax) {
        this.add((Filter)Filters.range(field, min, max, includeMin, includeMax));
    }

    public void addTerms(String field, Collection<?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        boolean used = false;
        TermsFilter filter = new TermsFilter();
        for (Object object : values) {
            String term = CoercionHelper.coerce(String.class, object);
            if (!StringUtils.isNotEmpty((String)term)) continue;
            filter.addTerm(new Term(field, term));
            used = true;
        }
        if (used) {
            this.add((Filter)filter);
        }
    }

    public void addTerms(String field, Object ... values) {
        if (values != null && values.length > 0) {
            this.addTerms(field, Arrays.asList(values));
        }
    }

    public Object clone() {
        Filters clone = new Filters();
        clone.filters.addAll(this.filters);
        return clone;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (!this.isValid()) {
            return null;
        }
        Filter[] array = this.filters.toArray(new Filter[this.filters.size()]);
        return Filters.and(array).getDocIdSet(reader);
    }

    public boolean isValid() {
        return CollectionUtils.isNotEmpty(this.filters);
    }
}

