/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.IndexOperationDAO;
import nl.strohalm.cyclos.entities.IndexOperation;
import nl.strohalm.cyclos.entities.IndexStatus;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.lucene.DocumentMapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class IndexHandler
implements InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(IndexHandler.class);
    private File indexRoot;
    private IndexOperationDAO indexOperationDao;
    private Map<Class<? extends Indexable>, DocumentMapper> documentMappers;
    private Map<Class<? extends Indexable>, Directory> directories;

    public static File resolveIndexRoot() {
        File bin = FileUtils.toFile((URL)IndexHandler.class.getResource("/"));
        File root = bin.getParentFile();
        if (!bin.getAbsolutePath().contains("WEB-INF") && new File(root, "web").exists()) {
            root = new File(root, "web/WEB-INF");
        }
        return new File(root, "indexes");
    }

    public void afterPropertiesSet() throws Exception {
        this.indexRoot = IndexHandler.resolveIndexRoot();
        if (!this.indexRoot.exists()) {
            this.indexRoot.mkdirs();
        }
        if (this.indexRoot == null) {
            throw new IllegalStateException("No write access to indexes directory");
        }
        this.directories = new HashMap<Class<? extends Indexable>, Directory>();
        for (IndexOperation.EntityType entityType : IndexOperation.EntityType.values()) {
            Class<? extends Indexable> entityClass = entityType.getEntityClass();
            File dir = this.getIndexDir(entityClass);
            FSDirectory directory = FSDirectory.open((File)dir);
            this.directories.put(entityClass, (Directory)directory);
        }
    }

    public void destroy() throws Exception {
        if (this.directories != null) {
            for (Map.Entry<Class<? extends Indexable>, Directory> entry : this.directories.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error closing index directory for " + entry.getKey()), (Throwable)e);
                }
            }
            this.directories = null;
        }
    }

    public Directory getDirectory(Class<? extends Indexable> entityType) {
        return this.directories.get(entityType);
    }

    public DocumentMapper getDocumentMapper(Class<? extends Indexable> entityType) {
        return this.documentMappers.get(entityType);
    }

    public File getIndexDir(Class<? extends Indexable> entityType) {
        return new File(this.indexRoot, ClassHelper.getClassName(entityType));
    }

    public File getIndexRoot() {
        return this.indexRoot;
    }

    public IndexStatus getIndexStatus(Class<? extends Indexable> entityType) {
        IndexReader reader;
        try {
            reader = this.doOpenReader(entityType);
        }
        catch (FileNotFoundException e) {
            return IndexStatus.MISSING;
        }
        catch (IOException e) {
            return IndexStatus.CORRUPT;
        }
        try {
            reader.isCurrent();
            IndexStatus e = IndexStatus.ACTIVE;
            return e;
        }
        catch (CorruptIndexException e) {
            IndexStatus indexStatus = IndexStatus.CORRUPT;
            return indexStatus;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while retrieving the index status for " + entityType), (Throwable)e);
            throw new DaoException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    public void index(Class<? extends Indexable> entityType, Long id) {
        this.createOperation(entityType, IndexOperation.OperationType.ADD, id);
    }

    public boolean indexesExists() {
        return this.indexRoot.exists() && this.indexRoot.list().length > 0;
    }

    public IndexReader openReader(Class<? extends Indexable> entityType) {
        try {
            return this.doOpenReader(entityType);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while opening index for read on " + entityType), (Throwable)e);
            throw new DaoException(e);
        }
    }

    public void rebuild(Class<? extends Indexable> entityType) {
        this.createOperation(entityType, IndexOperation.OperationType.REBUILD);
    }

    public void rebuildIfCorrupt(Class<? extends Indexable> entityType) {
        this.createOperation(entityType, IndexOperation.OperationType.REBUILD_IF_CORRUPT);
    }

    public void remove(Class<? extends Indexable> entityType, List<Long> ids) {
        for (Long id : ids) {
            this.remove(entityType, id);
        }
    }

    public void remove(Class<? extends Indexable> entityType, Long id) {
        this.createOperation(entityType, IndexOperation.OperationType.REMOVE, id);
    }

    public void setDocumentMappers(Map<Class<? extends Indexable>, DocumentMapper> documentMappers) {
        this.documentMappers = documentMappers;
    }

    public void setIndexOperationDao(IndexOperationDAO indexOperationDao) {
        this.indexOperationDao = indexOperationDao;
    }

    private IndexOperation createOperation(Class<? extends Indexable> entityType, IndexOperation.OperationType operationType) {
        return this.createOperation(entityType, operationType, null);
    }

    private IndexOperation createOperation(Class<? extends Indexable> entityType, IndexOperation.OperationType operationType, Long entityId) {
        IndexOperation operation = new IndexOperation();
        operation.setDate(Calendar.getInstance());
        operation.setEntityType(IndexOperation.EntityType.from(entityType));
        operation.setOperationType(operationType);
        operation.setEntityId(entityId);
        return this.indexOperationDao.insert(operation);
    }

    private IndexReader doOpenReader(Class<? extends Indexable> entityType) throws CorruptIndexException, IOException {
        return IndexReader.open((Directory)this.getDirectory(entityType), (boolean)true);
    }
}

