/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.io.Closeable;
import java.util.Iterator;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.utils.EntityHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public class IndexIterator<T extends Entity>
implements Iterator<T>,
Closeable {
    private Class<T> entityType;
    private Iterator<Integer> documentIterator;
    private IndexReader reader;
    private FetchDAO fetchDao;
    private Relationship[] fetch;

    public IndexIterator(Class<T> entityType, Iterator<Integer> documentIterator, IndexReader reader, FetchDAO fetchDao, Relationship ... fetch) {
        this.entityType = entityType;
        this.documentIterator = documentIterator;
        this.reader = reader;
        this.fetchDao = fetchDao;
        this.fetch = fetch;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        return this.documentIterator.hasNext();
    }

    @Override
    public T next() {
        Document document;
        Integer documentNumber = this.documentIterator.next();
        try {
            document = this.reader.document(documentNumber.intValue());
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
        Long id = Long.parseLong(document.get("id"));
        T entity = EntityHelper.reference(this.entityType, id);
        return this.fetchDao.fetch(entity, this.fetch);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

