/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nl.strohalm.cyclos.dao.IndexOperationDAO;
import nl.strohalm.cyclos.entities.IndexOperation;
import nl.strohalm.cyclos.entities.IndexStatus;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.instance.InstanceHandler;
import nl.strohalm.cyclos.utils.lucene.DocumentMapper;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import nl.strohalm.cyclos.utils.lucene.IndexOperationListener;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class IndexOperationRunner
implements Runnable,
InitializingBean,
DisposableBean {
    private static final String LAST_OPERATION_TIME = "lastOperationTime";
    private static final String LAST_OPERATION_ID = "lastOperationId";
    private static final long SLEEP_TIME = 20000L;
    private static final Log LOG = LogFactory.getLog(IndexOperationRunner.class);
    private Thread thread;
    private File statusFile;
    private Properties status;
    private Calendar lastOperationTime;
    private Long lastOperationId;
    private PlatformTransactionManager transactionManager;
    private TransactionHelper transactionHelper;
    private TransactionTemplate readonlyTransactionTemplate;
    private AlertServiceLocal alertService;
    private MessageResolver messageResolver;
    private IndexHandler indexHandler;
    private InstanceHandler instanceHandler;
    private SessionFactory sessionFactory;
    private Map<Class<?>, IndexWriter> cachedWriters;
    private SettingsServiceLocal settingsService;
    private ApplicationServiceLocal applicationService;
    private IndexOperationDAO indexOperationDao;
    private final List<IndexOperationListener> indexOperationListeners = new ArrayList<IndexOperationListener>();

    public void addIndexOperationListener(IndexOperationListener listener) {
        this.indexOperationListeners.add(listener);
    }

    public void afterPropertiesSet() throws Exception {
        this.readonlyTransactionTemplate = new TransactionTemplate(this.transactionManager);
        this.readonlyTransactionTemplate.setReadOnly(true);
        this.cachedWriters = new HashMap();
        this.statusFile = new File(this.indexHandler.getIndexRoot(), "status");
        this.status = new Properties();
        try {
            this.status.load(new FileReader(this.statusFile));
            long time = Long.parseLong(this.status.getProperty(LAST_OPERATION_TIME));
            this.lastOperationTime = new GregorianCalendar();
            this.lastOperationTime.setTimeInMillis(time);
            this.lastOperationId = Long.parseLong(this.status.getProperty(LAST_OPERATION_ID));
        }
        catch (Exception e) {
            this.lastOperationTime = null;
            this.lastOperationId = null;
        }
        this.thread = new Thread((Runnable)this, "IndexOperationRunner");
        this.thread.start();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        for (Map.Entry<Class<?>, IndexWriter> entry : this.cachedWriters.entrySet()) {
            try {
                IndexWriter writer = entry.getValue();
                writer.close();
            }
            catch (Exception e) {
                LOG.warn((Object)("Error closing index writer for " + ClassHelper.getClassName(entry.getKey())), (Throwable)e);
            }
        }
        this.cachedWriters.clear();
    }

    @Override
    public void run() {
        try {
            if (this.applicationService == null) {
                return;
            }
            while (!this.applicationService.isInitialized()) {
                Thread.sleep(20000L);
            }
            while (true) {
                try {
                    if (this.status.isEmpty()) {
                        this.initialRebuild();
                    } else {
                        this.runNextOperations();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error on IndexOperationRunner", (Throwable)e);
                }
                Thread.sleep(20000L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setIndexHandler(IndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void setIndexOperationDao(IndexOperationDAO indexOperationDao) {
        this.indexOperationDao = indexOperationDao;
    }

    public void setInstanceHandler(InstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    private void add(final Class<? extends Indexable> entityType, final Long id) {
        IndexWriter writer = null;
        try {
            writer = this.getWriter(entityType);
            final Analyzer analyzer = this.getAnalyzer();
            Document document = (Document)this.readonlyTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Document>(){

                public Document doInTransaction(TransactionStatus status) {
                    try {
                        Session session = IndexOperationRunner.this.getSession();
                        Indexable entity = (Indexable)session.load(entityType, (Serializable)id);
                        DocumentMapper documentMapper = IndexOperationRunner.this.indexHandler.getDocumentMapper(entityType);
                        if (entityType.equals(Member.class)) {
                            IndexOperationRunner.this.rebuildMemberAds(id, analyzer, session);
                        }
                        if (entityType.equals(Administrator.class) || entityType.equals(Member.class)) {
                            IndexOperationRunner.this.rebuildMemberRecords(id, analyzer, session);
                        }
                        return documentMapper.map(entity);
                    }
                    catch (ObjectNotFoundException e) {
                        return null;
                    }
                    catch (EntityNotFoundException e) {
                        return null;
                    }
                }
            });
            if (document != null) {
                writer.updateDocument(new Term("id", document.get("id")), document, analyzer);
                this.commit(entityType, writer);
            }
        }
        catch (CorruptIndexException e) {
            this.handleIndexCorrupted(entityType);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error adding entity to search index: " + ClassHelper.getClassName(entityType) + "#" + id), (Throwable)e);
            this.rollback(entityType, writer);
        }
    }

    private void commit(Class<? extends Indexable> entityType, IndexWriter writer) {
        try {
            writer.commit();
        }
        catch (CorruptIndexException e) {
            this.handleIndexCorrupted(entityType);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while committing index writer for " + ClassHelper.getClassName(entityType)), (Throwable)e);
        }
    }

    private void createAlert(final SystemAlert.Alerts type, final Class<? extends Indexable> entityType) {
        this.transactionHelper.runInNewTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IndexOperationRunner.this.alertService.create(type, IndexOperationRunner.this.resolveAlertArguments(entityType));
            }
        });
    }

    private Analyzer getAnalyzer() {
        return this.settingsService.getLocalSettings().getLanguage().getAnalyzer();
    }

    private Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    private synchronized IndexWriter getWriter(Class<? extends Indexable> entityType) {
        IndexWriter writer = this.cachedWriters.get(entityType);
        if (writer == null) {
            Analyzer analyzer = this.getAnalyzer();
            try {
                Directory directory = this.indexHandler.getDirectory(entityType);
                IndexWriter.unlock((Directory)directory);
                IndexWriterConfig config = new IndexWriterConfig(LuceneUtils.LUCENE_VERSION, analyzer);
                writer = new IndexWriter(directory, config);
                this.cachedWriters.put(entityType, writer);
            }
            catch (CorruptIndexException e) {
                this.handleIndexCorrupted(entityType);
                throw new DaoException(e);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while opening index for write on " + ClassHelper.getClassName(entityType)), (Throwable)e);
                throw new DaoException(e);
            }
        }
        return writer;
    }

    private void handleIndexCorrupted(Class<? extends Indexable> entityType) {
        LOG.error((Object)("Search index corrupted for " + ClassHelper.getClassName(entityType) + ". Rebuilding index..."));
        this.rebuild(entityType, true, true);
        LOG.info((Object)("Search index rebuilt after being corrupted for " + ClassHelper.getClassName(entityType)));
    }

    private void initialRebuild() {
        IndexOperation operation = (IndexOperation)this.readonlyTransactionTemplate.execute((TransactionCallback)new TransactionCallback<IndexOperation>(){

            public IndexOperation doInTransaction(TransactionStatus status) {
                return IndexOperationRunner.this.indexOperationDao.last();
            }
        });
        this.rebuildAll(operation);
    }

    private void persistStatus(Calendar time, Long id) {
        this.lastOperationTime = time;
        this.lastOperationId = id;
        if (this.lastOperationTime != null && this.lastOperationId != null) {
            this.status.setProperty(LAST_OPERATION_TIME, this.lastOperationTime.getTimeInMillis() + "");
            this.status.setProperty(LAST_OPERATION_ID, this.lastOperationId + "");
        } else {
            this.status.clear();
        }
        try {
            this.status.store(new FileWriter(this.statusFile), "");
        }
        catch (IOException e) {
            LOG.warn((Object)"Error while persisting indexing status", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild(final Class<? extends Indexable> entityType, boolean force, boolean createAlert) {
        IndexWriter indexWriter;
        boolean execute = true;
        if (!force) {
            IndexStatus status = this.indexHandler.getIndexStatus(entityType);
            boolean bl = execute = status != IndexStatus.CORRUPT && status != IndexStatus.MISSING;
        }
        if (!execute) {
            return;
        }
        if (createAlert) {
            this.createAlert(SystemAlert.Alerts.INDEX_REBUILD_START, entityType);
        }
        if ((indexWriter = this.cachedWriters.get(entityType)) != null) {
            try {
                indexWriter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.cachedWriters.remove(entityType);
        }
        File dir = this.indexHandler.getIndexDir(entityType);
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            // empty catch block
        }
        dir.mkdirs();
        final DocumentMapper documentMapper = this.indexHandler.getDocumentMapper(entityType);
        final IndexWriter writer = this.getWriter(entityType);
        boolean success = (Boolean)this.readonlyTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Boolean doInTransaction(TransactionStatus status) {
                Session session = IndexOperationRunner.this.getSession();
                ScrollableResults scroll = session.createQuery(IndexOperationRunner.this.resolveHql(entityType)).scroll(ScrollMode.FORWARD_ONLY);
                try {
                    int index = 0;
                    while (scroll.next()) {
                        Indexable entity = (Indexable)scroll.get(0);
                        Document document = documentMapper.map(entity);
                        try {
                            writer.addDocument(document);
                        }
                        catch (CorruptIndexException e) {
                            IndexOperationRunner.this.handleIndexCorrupted(entityType);
                            Boolean bl = false;
                            scroll.close();
                            return bl;
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Error while adding document to index after rebuilding " + ClassHelper.getClassName(entityType)), (Throwable)e);
                            Boolean bl = false;
                            scroll.close();
                            return bl;
                        }
                        if (++index % 30 != 0) continue;
                        session.clear();
                        IndexOperationRunner.this.commit(entityType, writer);
                    }
                    Boolean bl = true;
                    return bl;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    scroll.close();
                }
            }
        });
        try {
            if (success) {
                this.commit(entityType, writer);
            } else {
                this.rollback(entityType, writer);
            }
        }
        finally {
            if (createAlert) {
                this.createAlert(SystemAlert.Alerts.INDEX_REBUILD_END, entityType);
            }
        }
    }

    private void rebuildAll(IndexOperation last) {
        Calendar startTime = Calendar.getInstance();
        LOG.info((Object)"Rebuilding all search indexes...");
        this.createAlert(SystemAlert.Alerts.INDEX_REBUILD_START, null);
        for (IndexOperation.EntityType type : IndexOperation.EntityType.values()) {
            long indexStart = System.currentTimeMillis();
            Class<? extends Indexable> entityClass = type.getEntityClass();
            this.rebuild(entityClass, true, false);
            LOG.debug((Object)("Search index for " + ClassHelper.getClassName(entityClass) + " was rebuilt in " + DateHelper.secondsSince(indexStart) + "s"));
        }
        LOG.info((Object)("All search indexes rebuilt in " + DateHelper.secondsSince(startTime.getTimeInMillis()) + "s"));
        this.createAlert(SystemAlert.Alerts.INDEX_REBUILD_END, null);
        Calendar time = last == null ? startTime : last.getDate();
        Long id = last == null ? 0L : last.getId();
        this.persistStatus(time, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebuildMemberAds(Long userId, Analyzer analyzer, Session session) {
        Class<Ad> entityType = Ad.class;
        IndexWriter writer = this.getWriter(entityType);
        boolean success = false;
        DocumentMapper documentMapper = this.indexHandler.getDocumentMapper(entityType);
        try {
            writer.deleteDocuments(new Term("owner", userId.toString()));
        }
        catch (CorruptIndexException e) {
            this.handleIndexCorrupted(entityType);
            success = false;
        }
        catch (IOException e) {
            LOG.error((Object)"Error while reindexing a member's advertisements", (Throwable)e);
            success = false;
        }
        ScrollableResults scroll = session.createQuery("from Ad a where a.deleteDate is null and a.owner.id = " + userId).scroll(ScrollMode.FORWARD_ONLY);
        try {
            int index = 0;
            while (scroll.next()) {
                Indexable entity = (Indexable)scroll.get(0);
                Document document = documentMapper.map(entity);
                try {
                    writer.addDocument(document, analyzer);
                }
                catch (CorruptIndexException e) {
                    this.handleIndexCorrupted(entityType);
                    success = false;
                    break;
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while adding advertisements to index", (Throwable)e);
                    success = false;
                    break;
                }
                if (++index % 30 != 0) continue;
                session.clear();
            }
            success = true;
        }
        finally {
            scroll.close();
        }
        if (success) {
            this.commit(entityType, writer);
            return true;
        }
        this.rollback(entityType, writer);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebuildMemberRecords(Long userId, Analyzer analyzer, Session session) {
        Class<MemberRecord> entityType = MemberRecord.class;
        IndexWriter writer = this.getWriter(entityType);
        boolean success = false;
        DocumentMapper documentMapper = this.indexHandler.getDocumentMapper(entityType);
        try {
            writer.deleteDocuments(new Term("element", userId.toString()));
        }
        catch (CorruptIndexException e) {
            this.handleIndexCorrupted(entityType);
            success = false;
        }
        catch (IOException e) {
            LOG.error((Object)"Error while reindexing an user's records", (Throwable)e);
            success = false;
        }
        ScrollableResults scroll = session.createQuery("from MemberRecord mr where mr.element.id = " + userId).scroll(ScrollMode.FORWARD_ONLY);
        try {
            int index = 0;
            while (scroll.next()) {
                Indexable entity = (Indexable)scroll.get(0);
                Document document = documentMapper.map(entity);
                try {
                    writer.addDocument(document, analyzer);
                }
                catch (CorruptIndexException e) {
                    this.handleIndexCorrupted(entityType);
                    success = false;
                    break;
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while adding member records to index", (Throwable)e);
                    success = false;
                    break;
                }
                if (++index % 30 != 0) continue;
                session.clear();
            }
            success = true;
        }
        finally {
            scroll.close();
        }
        if (success) {
            this.commit(entityType, writer);
            return true;
        }
        this.rollback(entityType, writer);
        return false;
    }

    private void remove(Class<? extends Indexable> entityType, Long id) {
        IndexWriter writer = this.getWriter(entityType);
        try {
            writer.deleteDocuments((Query)new TermQuery(new Term("id", id.toString())));
            this.commit(entityType, writer);
        }
        catch (CorruptIndexException e) {
            this.handleIndexCorrupted(entityType);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error removing from index " + ClassHelper.getClassName(entityType) + "#" + id), (Throwable)e);
            this.rollback(entityType, writer);
        }
    }

    private Object[] resolveAlertArguments(Class<? extends Indexable> type) {
        String suffix = type == null ? "all" : ClassHelper.getClassName(type);
        return new Object[]{this.messageResolver.message("adminTasks.indexes.type." + suffix, new Object[0]), this.instanceHandler.getId()};
    }

    private String resolveHql(Class<? extends Indexable> entityClass) {
        if (entityClass.equals(Ad.class)) {
            return "from Ad a where deleteDate is null";
        }
        return "from " + entityClass.getName();
    }

    private synchronized void rollback(Class<? extends Indexable> entityType, IndexWriter writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.rollback();
        }
        catch (Exception e) {
            LOG.error((Object)("Error while rolling back index writer for " + ClassHelper.getClassName(entityType)), (Throwable)e);
        }
        this.cachedWriters.remove(entityType);
    }

    private void runNextOperations() {
        boolean hasMore = true;
        while (hasMore) {
            IndexOperation operation = (IndexOperation)this.readonlyTransactionTemplate.execute((TransactionCallback)new TransactionCallback<IndexOperation>(){

                public IndexOperation doInTransaction(TransactionStatus txStatus) {
                    IndexOperation operation = IndexOperationRunner.this.indexOperationDao.next(IndexOperationRunner.this.lastOperationTime, IndexOperationRunner.this.lastOperationId);
                    if (operation == null) {
                        return null;
                    }
                    if ((System.currentTimeMillis() - operation.getDate().getTimeInMillis()) % 3600000L < 24L) {
                        IndexOperationRunner.this.rebuildAll(operation);
                        IndexOperation indexOperation = new IndexOperation();
                        indexOperation.setOperationType(IndexOperation.OperationType.REBUILD);
                        return indexOperation;
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Running index operation: " + operation));
                        }
                        IndexOperationRunner.this.runOperation(operation);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Finished index operation: " + operation + " in " + DateHelper.secondsSince(startTime) + "s"));
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.warn((Object)("Error running index operation " + operation), (Throwable)e);
                        throw e;
                    }
                    finally {
                        IndexOperationRunner.this.persistStatus(operation.getDate(), operation.getId());
                    }
                    return operation;
                }
            });
            if (operation != null) {
                for (IndexOperationListener listener : this.indexOperationListeners) {
                    listener.onComplete(operation);
                }
            }
            hasMore = operation != null;
        }
    }

    private void runOperation(IndexOperation operation) {
        Class<? extends Indexable> entityClass = operation.getEntityType().getEntityClass();
        IndexOperation.OperationType operationType = operation.getOperationType();
        switch (operationType) {
            case REBUILD: {
                this.rebuild(entityClass, true, true);
                break;
            }
            case REBUILD_IF_CORRUPT: {
                this.rebuild(entityClass, false, true);
                break;
            }
            case ADD: {
                this.add(entityClass, operation.getEntityId());
                break;
            }
            case REMOVE: {
                this.remove(entityClass, operation.getEntityId());
            }
        }
    }
}

