/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class LuceneFormatter {
    public static String MAX_DECIMAL = "9999999999999999.999999";
    public static String MIN_DECIMAL = "-999999999999999.999999";
    public static String MAX_DATE = "99999999999999";
    public static String MIN_DATE = "00000000000000";
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static DecimalFormat NUMBER_FORMAT = new DecimalFormat("0000000000000000");
    private static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0000000000000000.000000", new DecimalFormatSymbols(Locale.US));

    public static String format(Calendar date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT.format(date.getTime());
    }

    public static String format(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Integer || number instanceof Long || number instanceof BigInteger) {
            return NUMBER_FORMAT.format(number.longValue());
        }
        return DECIMAL_FORMAT.format(number.doubleValue());
    }
}

