/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.lucene;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.lucene.DocsIterator;
import nl.strohalm.cyclos.utils.lucene.Filters;
import nl.strohalm.cyclos.utils.lucene.IdFieldSelector;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import nl.strohalm.cyclos.utils.query.PageImpl;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;

public class LuceneQueryHandler {
    private IndexHandler indexHandler;
    private FetchDAO fetchDao;

    public <E extends Entity> List<E> executeQuery(Class<E> entityType, Query query, Filter filter, Sort sort, QueryParameters.ResultType resultType, PageParameters pageParameters, Relationship ... fetch) {
        if (filter instanceof Filters && !((Filters)filter).isValid()) {
            filter = null;
        }
        switch (resultType) {
            case ITERATOR: {
                return this.iterator(entityType, query, filter, sort, pageParameters, fetch);
            }
        }
        return this.listOrPage(entityType, query, filter, sort, resultType, pageParameters, fetch);
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setIndexHandler(IndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public <E extends Entity> E toEntity(IndexReader reader, int docId, Class<E> entityType, Relationship ... fetch) {
        try {
            Document doc = reader.document(docId, (FieldSelector)IdFieldSelector.getInstance());
            long id = Long.parseLong(doc.get("id"));
            E entity = EntityHelper.reference(entityType, id);
            entity = this.fetchDao.fetch(entity, fetch);
            return entity;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    private <E extends Entity> List<E> iterator(Class<E> entityType, Query query, Filter filter, Sort sort, PageParameters pageParameters, Relationship ... fetch) {
        IndexReader reader;
        IndexSearcher searcher = null;
        try {
            reader = this.indexHandler.openReader(entityType);
        }
        catch (DaoException e) {
            return new IteratorListImpl(Collections.emptyList().iterator());
        }
        int firstResult = pageParameters == null ? 0 : pageParameters.getFirstResult();
        int maxResults = pageParameters == null || pageParameters.getMaxResults() == 0 ? Integer.MAX_VALUE : pageParameters.getMaxResults() + firstResult;
        try {
            searcher = new IndexSearcher(reader);
            Object topDocs = sort == null || ArrayUtils.isEmpty((Object[])sort.getSort()) ? searcher.search(query, filter, maxResults) : searcher.search(query, filter, maxResults, sort);
            DocsIterator<E> iterator = new DocsIterator<E>(this, entityType, reader, (TopDocs)topDocs, firstResult, fetch);
            DataIteratorHelper.registerOpen(iterator, false);
            IteratorListImpl<E> iteratorListImpl = new IteratorListImpl<E>(iterator);
            return iteratorListImpl;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
        finally {
            try {
                searcher.close();
            }
            catch (Exception e) {}
        }
    }

    private <E extends Entity> List<E> listOrPage(Class<E> entityType, Query query, Filter filter, Sort sort, QueryParameters.ResultType resultType, PageParameters pageParameters, Relationship ... fetch) {
        ArrayList arrayList;
        IndexReader reader;
        IndexSearcher searcher = null;
        try {
            reader = this.indexHandler.openReader(entityType);
        }
        catch (DaoException e) {
            return Collections.emptyList();
        }
        int firstResult = pageParameters == null ? 0 : pageParameters.getFirstResult();
        int maxResults = pageParameters == null ? Integer.MAX_VALUE : pageParameters.getMaxResults() + firstResult;
        try {
            searcher = new IndexSearcher(reader);
            if (maxResults == 0 && resultType == QueryParameters.ResultType.PAGE) {
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search(query, filter, (Collector)collector);
                int totalHits = collector.getTotalHits();
                PageImpl pageImpl = new PageImpl(pageParameters, totalHits, Collections.emptyList());
                return pageImpl;
            }
            if (maxResults == 0) {
                maxResults = Integer.MAX_VALUE;
            }
            Object topDocs = sort == null || ArrayUtils.isEmpty((Object[])sort.getSort()) ? searcher.search(query, filter, maxResults) : searcher.search(query, filter, maxResults, sort);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            AbstractList list = new ArrayList(Math.min(firstResult, scoreDocs.length));
            for (int i = firstResult; i < scoreDocs.length; ++i) {
                ScoreDoc scoreDoc = scoreDocs[i];
                E entity = this.toEntity(reader, scoreDoc.doc, entityType, fetch);
                if (entity == null) continue;
                list.add(entity);
            }
            if (resultType == QueryParameters.ResultType.PAGE) {
                list = new PageImpl(pageParameters, topDocs.totalHits, list);
            }
            arrayList = list;
        }
        catch (EntityNotFoundException e) {
            throw new ValidationException("general.error.indexedRecordNotFound", new Object[0]);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
        finally {
            try {
                searcher.close();
            }
            catch (Exception e) {}
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        return arrayList;
    }
}

