/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.notifications;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntry;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.preferences.AdminNotificationPreferenceQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.EnumHelper;
import nl.strohalm.cyclos.utils.LinkGenerator;
import nl.strohalm.cyclos.utils.MailHandler;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.annotation.AfterReturning;

public class AdminNotificationHandlerImpl
implements AdminNotificationHandler {
    private static final Relationship[] TRANSFER_FETCH = new Relationship[]{RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.FROM, Account.Relationships.TYPE), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, Account.Relationships.TYPE), Payment.Relationships.TYPE};
    private PreferenceServiceLocal preferenceService;
    private SettingsServiceLocal settingsService;
    private FetchServiceLocal fetchService;
    private PermissionServiceLocal permissionService;
    private MailHandler mailHandler;
    private LinkGenerator linkGenerator;
    private MessageResolver messageResolver = new MessageResolver.NoOpMessageResolver();

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.alerts.AlertServiceLocal.create(..))", returning="alert", argNames="alert")
    public void notifyAlert(Alert alert) {
        String subject;
        boolean isMember = alert instanceof MemberAlert;
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        String key = alert.getKey();
        Map<String, Object> variables = null;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        if (isMember) {
            MemberAlert memberAlert = this.fetchService.fetch((MemberAlert)alert, RelationshipHelper.nested(MemberAlert.Relationships.MEMBER, Element.Relationships.GROUP));
            Member member = memberAlert.getMember();
            query.setMemberAlert(EnumHelper.findByValue(MemberAlert.Alerts.class, key));
            query.setMemberGroup(member.getMemberGroup());
            variables = member.getVariableValues(localSettings);
            subject = messageSettings.getAdminMemberAlertSubject();
        } else {
            query.setSystemAlert(EnumHelper.findByValue(SystemAlert.Alerts.class, key));
            subject = messageSettings.getAdminSystemAlertSubject();
        }
        List<String> args = Arrays.asList(alert.getArg0(), alert.getArg1(), alert.getArg2(), alert.getArg3(), alert.getArg4());
        String body = this.messageResolver.message(key, args);
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(null);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(false);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        boolean enqueue = SystemAlert.Alerts.APPLICATION_SHUTDOWN != query.getSystemAlert();
        this.send(queryDTO, enqueue);
    }

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal.insert(..))", returning="errorLog", argNames="errorLog")
    public void notifyApplicationErrors(ErrorLogEntry errorLog) {
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        query.setApplicationErrors(true);
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getAdminApplicationErrorSubject();
        String body = messageSettings.getAdminApplicationErrorMessage();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("path", errorLog.getPath());
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(errorLog);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(true);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.elements.MessageServiceLocal.sendFromMemberToAdmin(..))", argNames="message", returning="message")
    public void notifyMessage(Message message) {
        MessageCategory category = (message = this.fetchService.fetch(message, RelationshipHelper.nested(Message.Relationships.FROM_MEMBER, Element.Relationships.GROUP), Message.Relationships.CATEGORY)).getCategory();
        if (category == null) {
            return;
        }
        Member fromMember = message.getFromMember();
        boolean isHtml = message.isHtml();
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        query.setMessageCategory(category);
        query.setMemberGroup(fromMember.getMemberGroup());
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(message.getSubject());
        sendDTO.setBody(message.getBody());
        sendDTO.setRelatedEntity(null);
        sendDTO.setVariables(null);
        sendDTO.setHtml(isHtml);
        sendDTO.setCategory(category);
        sendDTO.setFromMember(fromMember);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    @Override
    @AfterReturning(pointcut="(execution(* nl.strohalm.cyclos.services.transactions.PaymentServiceLocal.doPaymentAsMemberToMember(..))) || (execution(* nl.strohalm.cyclos.services.transactions.PaymentServiceLocal.doPaymentFromMemberToMember(..))) || (execution(* nl.strohalm.cyclos.services.transactions.PaymentServiceLocal.doPaymentFromSystemToMember(..))) || (execution(* nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal.authorize*(..)))", argNames="transfer", returning="transfer")
    public void notifyNewPendingPayment(Transfer transfer) {
        if (transfer.getProcessDate() != null) {
            return;
        }
        AuthorizationLevel authorizationLevel = this.fetchService.fetch(transfer.getNextAuthorizationLevel(), AuthorizationLevel.Relationships.ADMIN_GROUPS);
        if (authorizationLevel == null || CollectionUtils.isEmpty(authorizationLevel.getAdminGroups())) {
            return;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        AccountOwner fromOwner = transfer.getFromOwner();
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(transfer.getVariableValues(localSettings));
        variables.putAll(fromOwner.getVariableValues(localSettings));
        if (fromOwner instanceof Member) {
            Member fromMember = this.fetchService.fetch((Member)fromOwner, Element.Relationships.GROUP);
            query.setMemberGroup(fromMember.getMemberGroup());
        } else {
            variables.put("member", localSettings.getApplicationUsername());
            variables.put("login", transfer.getFrom().getOwnerName());
            query.setAccountTypes(Arrays.asList((SystemAccountType)this.fetchService.fetch(transfer.getFrom().getType(), new Relationship[0])));
        }
        query.setAdminGroups(authorizationLevel.getAdminGroups());
        query.setNewPendingPayment(transfer.getType());
        String subject = messageSettings.getAdminNewPendingPaymentSubject();
        String body = messageSettings.getAdminNewPendingPaymentMessage();
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(transfer);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(true);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.elements.ElementServiceLocal.publicRegisterMember(..)) || execution(* nl.strohalm.cyclos.services.elements.ElementServiceLocal.publicValidateRegistration(..))", returning="registeredMember", argNames="registeredMember")
    public void notifyNewPublicRegistration(Member member) {
        MemberGroup group = member.getMemberGroup();
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        query.setNewMemberGroup(group);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getAdminNewMemberSubject();
        String body = messageSettings.getAdminNewMemberMessage();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("group", group.getName());
        variables.putAll(member.getVariableValues(localSettings));
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(member);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(true);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.transactions.PaymentServiceLocal.doPayment*(..)) || execution(* nl.strohalm.cyclos.services.transactions.PaymentServiceLocal.doSelfPayment(..))", argNames="transfer", returning="transfer")
    public void notifyPayment(Transfer transfer) {
        Member member;
        String body;
        String subject;
        transfer = this.fetchService.fetch(transfer, TRANSFER_FETCH);
        Account from = transfer.getFrom();
        Account to = transfer.getTo();
        if (!(from instanceof SystemAccount) && !(to instanceof SystemAccount)) {
            return;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        HashSet<SystemAccountType> accountTypes = new HashSet<SystemAccountType>();
        if (from instanceof MemberAccount) {
            subject = messageSettings.getAdminPaymentFromMemberToSystemSubject();
            body = messageSettings.getAdminPaymentFromMemberToSystemMessage();
            accountTypes.add((SystemAccountType)to.getType());
            member = ((MemberAccount)from).getMember();
        } else if (to instanceof MemberAccount) {
            subject = messageSettings.getAdminPaymentFromSystemToMemberSubject();
            body = messageSettings.getAdminPaymentFromSystemToMemberMessage();
            accountTypes.add((SystemAccountType)from.getType());
            member = ((MemberAccount)to).getMember();
        } else {
            subject = messageSettings.getAdminPaymentFromSystemToSystemSubject();
            body = messageSettings.getAdminPaymentFromSystemToSystemMessage();
            accountTypes.add((SystemAccountType)from.getType());
            accountTypes.add((SystemAccountType)to.getType());
            member = null;
        }
        if (member != null) {
            variables.putAll(member.getVariableValues(localSettings));
        }
        variables.putAll(transfer.getVariableValues(localSettings));
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        query.setTransferType(transfer.getType());
        query.setAccountTypes(accountTypes);
        if (member != null) {
            member = this.fetchService.fetch(member, Element.Relationships.GROUP);
            query.setMemberGroup(member.getMemberGroup());
        }
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(transfer);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(true);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    @Override
    @AfterReturning(pointcut="(execution(* nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal.changeStatus(..)))", argNames="guarantee", returning="guarantee")
    public void notifyPendingGuarantee(Guarantee guarantee) {
        this.doNotifyPendingGuarantee(guarantee);
    }

    @Override
    @AfterReturning(pointcut="execution(* nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal.sendFromMemberToSystem(..))", returning="invoice", argNames="invoice")
    public void notifySystemInvoice(Invoice invoice) {
        AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
        query.setSystemInvoices(true);
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getAdminSystemInvoiceSubject();
        String body = messageSettings.getAdminSystemInvoiceMessage();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(invoice.getVariableValues(localSettings));
        variables.putAll(invoice.getFromMember().getVariableValues(localSettings));
        SendDTO sendDTO = new SendDTO();
        sendDTO.setSubject(subject);
        sendDTO.setBody(body);
        sendDTO.setRelatedEntity(invoice);
        sendDTO.setVariables(variables);
        sendDTO.setHtml(true);
        sendDTO.setCategory(null);
        sendDTO.setFromMember(null);
        QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
        this.send(queryDTO);
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    public void setMailHandler(MailHandler mailHandler) {
        this.mailHandler = mailHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    private void doNotifyPendingGuarantee(Guarantee guarantee) {
        if (guarantee.getStatus() == Guarantee.Status.PENDING_ADMIN) {
            guarantee = this.fetchService.fetch(guarantee, Guarantee.Relationships.GUARANTEE_TYPE);
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            AdminNotificationPreferenceQuery query = new AdminNotificationPreferenceQuery();
            query.setGuaranteeType(guarantee.getGuaranteeType());
            String subject = null;
            String body = null;
            if (guarantee.getGuaranteeType().getModel() == GuaranteeType.Model.WITH_BUYER_ONLY) {
                subject = messageSettings.getAdminPendingBuyerOnlyGuaranteeSubject();
                body = messageSettings.getAdminPendingBuyerOnlyGuaranteeMessage();
            } else {
                subject = messageSettings.getAdminPendingGuaranteeSubject();
                body = messageSettings.getAdminPendingGuaranteeMessage();
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(guarantee.getVariableValues(localSettings));
            SendDTO sendDTO = new SendDTO();
            sendDTO.setSubject(subject);
            sendDTO.setBody(body);
            sendDTO.setRelatedEntity(guarantee);
            sendDTO.setVariables(variables);
            sendDTO.setHtml(true);
            sendDTO.setCategory(null);
            sendDTO.setFromMember(null);
            QuerySendDTO queryDTO = new QuerySendDTO(query, sendDTO);
            this.send(queryDTO);
        }
    }

    private void send(AdminSendDTO adminDTO, boolean enqueue) {
        boolean active = this.permissionService.hasPermission(adminDTO.getAdmin().getGroup(), BasicPermission.BASIC_LOGIN);
        if (!active) {
            return;
        }
        String email = adminDTO.getAdmin().getEmail();
        if (StringUtils.isEmpty((String)email)) {
            return;
        }
        SendDTO sendDTO = adminDTO.getSendDTO();
        if (sendDTO.getRelatedEntity() != null && this.linkGenerator != null) {
            sendDTO.getVariables().put("link", this.linkGenerator.generateLinkFor(adminDTO.getAdmin(), sendDTO.getRelatedEntity()));
        }
        String body = this.mailHandler.processBody(adminDTO.getAdmin(), sendDTO.getBody(), sendDTO.getFromMember(), sendDTO.getCategory(), sendDTO.isHtml());
        String processedSubject = MessageProcessingHelper.processVariables(sendDTO.getSubject(), sendDTO.getVariables());
        String processedBody = MessageProcessingHelper.processVariables(body, sendDTO.getVariables());
        if (enqueue) {
            this.mailHandler.sendAfterTransactionCommit(processedSubject, null, this.mailHandler.getInternetAddress(adminDTO.getAdmin()), processedBody, sendDTO.isHtml());
        } else {
            this.mailHandler.send(processedSubject, null, this.mailHandler.getInternetAddress(adminDTO.getAdmin()), processedBody, sendDTO.isHtml());
        }
    }

    private void send(QuerySendDTO queryDTO) {
        this.send(queryDTO, true);
    }

    private void send(QuerySendDTO queryDTO, boolean enqueue) {
        List<Administrator> admins = this.preferenceService.listAdminsForNotification(queryDTO.getQuery());
        AdminSendDTO adminDTO = new AdminSendDTO();
        adminDTO.setSendDTO(queryDTO.getSendDTO());
        for (Administrator admin : admins) {
            adminDTO.setAdmin(admin);
            this.send(adminDTO, enqueue);
        }
    }

    private class SendDTO {
        private String subject;
        private String body;
        private Entity relatedEntity;
        private Map<String, Object> variables;
        private boolean isHtml;
        private MessageCategory category;
        private Member fromMember;

        private SendDTO() {
        }

        public String getBody() {
            return this.body;
        }

        public MessageCategory getCategory() {
            return this.category;
        }

        public Member getFromMember() {
            return this.fromMember;
        }

        public Entity getRelatedEntity() {
            return this.relatedEntity;
        }

        public String getSubject() {
            return this.subject;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public boolean isHtml() {
            return this.isHtml;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setCategory(MessageCategory category) {
            this.category = category;
        }

        public void setFromMember(Member fromMember) {
            this.fromMember = fromMember;
        }

        public void setHtml(boolean isHtml) {
            this.isHtml = isHtml;
        }

        public void setRelatedEntity(Entity relatedEntity) {
            this.relatedEntity = relatedEntity;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }
    }

    private class QuerySendDTO {
        private final AdminNotificationPreferenceQuery query;
        private final SendDTO sendDTO;

        public QuerySendDTO(AdminNotificationPreferenceQuery query, SendDTO sendDTO) {
            this.query = query;
            this.sendDTO = sendDTO;
        }

        public AdminNotificationPreferenceQuery getQuery() {
            return this.query;
        }

        public SendDTO getSendDTO() {
            return this.sendDTO;
        }
    }

    private class AdminSendDTO {
        private Administrator admin;
        private SendDTO sendDTO;

        private AdminSendDTO() {
        }

        public Administrator getAdmin() {
            return this.admin;
        }

        public SendDTO getSendDTO() {
            return this.sendDTO;
        }

        public void setAdmin(Administrator admin) {
            this.admin = admin;
        }

        public void setSendDTO(SendDTO sendDTO) {
            this.sendDTO = sendDTO;
        }
    }
}

