/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.notifications;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.entities.members.TransactionFeedbackRequest;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationServiceLocal;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.ChangeBrokerDTO;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendMessageFromSystemDTO;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.preferences.MessageChannel;
import nl.strohalm.cyclos.services.preferences.PreferenceServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MemberNotificationHandlerImpl
implements MemberNotificationHandler {
    private static final float PRECISION_DELTA = 1.0E-4f;
    private AccountServiceLocal accountService;
    private BrokeringServiceLocal brokeringService;
    private CertificationServiceLocal certificationService;
    private ChannelServiceLocal channelService;
    private FetchServiceLocal fetchService;
    private GroupServiceLocal groupService;
    private InvoiceServiceLocal invoiceService;
    private MessageServiceLocal messageService;
    private SettingsServiceLocal settingsService;
    private MessageResolver messageResolver;
    private PreferenceServiceLocal preferenceService;
    private AdminNotificationHandler adminNotificationHandler;

    @Override
    public void acceptedInvoiceNotification(Invoice invoice) {
        Member destinationMember = invoice.getFromMember();
        if (destinationMember == null) {
            return;
        }
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getInvoiceAcceptedSubject();
        String body = messageSettings.getInvoiceAcceptedMessage();
        String sms = messageSettings.getInvoiceAcceptedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, invoice.getTo(), invoice);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, invoice.getTo(), invoice);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, invoice.getTo(), invoice);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.INVOICE);
        message.setEntity(invoice);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
        this.notifyTransactionFeedbackRequest(invoice.getTransfer());
    }

    @Override
    public void automaticPaymentReceivedNotification(Transfer transfer, TransferDTO dto) {
        Member destinationMember;
        Set<MessageChannel> channels;
        if ((transfer = this.fetchService.fetch(transfer, RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), Payment.Relationships.TYPE)).isRoot() && !transfer.isToSystem() && !(channels = this.preferenceService.receivedChannels(destinationMember = (Member)transfer.getTo().getOwner(), Message.Type.PAYMENT)).isEmpty()) {
            boolean sendSmsNotification;
            AccountStatus status = null;
            boolean bl = sendSmsNotification = transfer.getType().isAllowSmsNotification() && channels.contains((Object)MessageChannel.SMS);
            if (sendSmsNotification) {
                status = this.accountService.getCurrentStatus(new AccountDTO(transfer.getTo()));
            }
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            String subject = null;
            String body = null;
            String sms = null;
            if (transfer.getAccountFeeLog() != null) {
                subject = messageSettings.getAccountFeeReceivedSubject();
                body = messageSettings.getAccountFeeReceivedMessage();
                if (sendSmsNotification) {
                    sms = messageSettings.getAccountFeeReceivedSms();
                }
                subject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)destinationMember, transfer, transfer.getAccountFeeLog().getAccountFee());
                body = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)destinationMember, transfer, transfer.getAccountFeeLog().getAccountFee());
                if (sendSmsNotification) {
                    sms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)destinationMember, status, transfer, transfer.getAccountFeeLog().getAccountFee());
                }
            } else {
                if (transfer.getProcessDate() == null) {
                    subject = messageSettings.getPendingPaymentReceivedSubject();
                    body = messageSettings.getPendingPaymentReceivedMessage();
                    if (sendSmsNotification) {
                        sms = messageSettings.getPendingPaymentReceivedSms();
                    }
                } else {
                    subject = messageSettings.getPaymentReceivedSubject();
                    body = messageSettings.getPaymentReceivedMessage();
                    if (sendSmsNotification) {
                        sms = messageSettings.getPaymentReceivedSms();
                    }
                }
                subject = MessageProcessingHelper.processVariables(subject, localSettings, transfer.getFrom().getOwner(), transfer);
                body = MessageProcessingHelper.processVariables(body, localSettings, transfer.getFrom().getOwner(), transfer);
                if (sendSmsNotification) {
                    sms = MessageProcessingHelper.processVariables(sms, localSettings, transfer.getFrom().getOwner(), status, transfer);
                }
            }
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.PAYMENT);
            message.setEntity(transfer);
            message.setToMember(destinationMember);
            message.setSubject(subject);
            message.setBody(body);
            message.setSms(sms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void blockedCredentialsNotification(User user, Channel.Credentials credentialsType) {
        if (user instanceof MemberUser) {
            String sms;
            String body;
            String subject;
            boolean skipSms = false;
            try {
                Channel smsChannel;
                Channel currentChannel = (Channel)Class.forName("nl.strohalm.cyclos.webservices.WebServiceContext").getMethod("getChannel", new Class[0]).invoke(null, new Object[0]);
                if (currentChannel != null && currentChannel.equals(smsChannel = this.channelService.getSmsChannel())) {
                    skipSms = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Member member = (Member)user.getElement();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            switch (credentialsType) {
                case LOGIN_PASSWORD: {
                    subject = messageSettings.getLoginBlockedSubject();
                    body = messageSettings.getLoginBlockedMessage();
                    sms = skipSms ? null : messageSettings.getLoginBlockedSms();
                    break;
                }
                case TRANSACTION_PASSWORD: {
                    subject = messageSettings.getMaxTransactionPasswordTriesSubject();
                    body = messageSettings.getMaxTransactionPasswordTriesMessage();
                    sms = skipSms ? null : messageSettings.getMaxTransactionPasswordTriesSms();
                    break;
                }
                case PIN: {
                    subject = messageSettings.getPinBlockedSubject();
                    body = messageSettings.getPinBlockedMessage();
                    sms = skipSms ? null : messageSettings.getPinBlockedSms();
                    break;
                }
                case CARD_SECURITY_CODE: {
                    subject = messageSettings.getCardSecurityCodeBlockedSubject();
                    body = messageSettings.getCardSecurityCodeBlockedMessage();
                    sms = skipSms ? null : messageSettings.getCardSecurityCodeBlockedSms();
                    break;
                }
                default: {
                    return;
                }
            }
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            String processedSubject = MessageProcessingHelper.processVariables(subject, member, localSettings);
            String processedBody = MessageProcessingHelper.processVariables(body, member, localSettings);
            String processedSms = sms == null ? null : MessageProcessingHelper.processVariables(sms, member, localSettings);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.ACCESS);
            message.setToMember(member);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void cancelledInvoiceNotification(Invoice invoice) {
        if (!invoice.isToSystem()) {
            Member destinationMember = invoice.getToMember();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            String subject = messageSettings.getInvoiceCancelledSubject();
            String body = messageSettings.getInvoiceCancelledMessage();
            String sms = messageSettings.getInvoiceCancelledSms();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, invoice.getFrom(), invoice);
            String processedBody = MessageProcessingHelper.processVariables(body, localSettings, invoice.getFrom(), invoice);
            String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, invoice.getFrom(), invoice);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.INVOICE);
            message.setEntity(invoice);
            message.setToMember(destinationMember);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void certificationCanceledNotification(Long certificationId) {
        Certification certification = this.certificationService.load(certificationId, Certification.Relationships.BUYER, Certification.Relationships.ISSUER);
        this.certificationStatusChangedNotification(certification);
    }

    @Override
    public void certificationIssuedNotification(Certification certification) {
        if (certification.getStatus() == Certification.Status.ACTIVE) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            Member buyer = certification.getBuyer();
            String subjectBuyer = messageSettings.getCertificationIssuedSubject();
            String bodyBuyer = messageSettings.getCertificationIssuedMessage();
            String smsBuyer = messageSettings.getCertificationIssuedSms();
            String processedSubjectBuyer = MessageProcessingHelper.processVariables(subjectBuyer, certification, localSettings);
            String processedBodyBuyer = MessageProcessingHelper.processVariables(bodyBuyer, certification, localSettings);
            String processedSmsBuyer = MessageProcessingHelper.processVariables(smsBuyer, certification, localSettings);
            SendMessageFromSystemDTO messageToBuyer = new SendMessageFromSystemDTO();
            messageToBuyer.setEntity(certification);
            messageToBuyer.setType(Message.Type.CERTIFICATION);
            messageToBuyer.setToMember(buyer);
            messageToBuyer.setSubject(processedSubjectBuyer);
            messageToBuyer.setBody(processedBodyBuyer);
            messageToBuyer.setSms(processedSmsBuyer);
            this.messageService.sendFromSystem(messageToBuyer);
        }
    }

    @Override
    public void certificationStatusChangedNotification(Certification certification) {
        if (certification.getStatus() == Certification.Status.SCHEDULED) {
            return;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String statusString = this.messageResolver.message("certification.status." + certification.getStatus().toString(), new Object[0]);
        Map<String, Object> variables = certification.getVariableValues(localSettings);
        variables.put("status", statusString);
        Member buyer = certification.getBuyer();
        String subjectBuyer = messageSettings.getCertificationStatusChangedSubject();
        String bodyBuyer = messageSettings.getCertificationStatusChangedMessage();
        String smsBuyer = messageSettings.getCertificationStatusChangedSms();
        String processedSubjectBuyer = MessageProcessingHelper.processVariables(subjectBuyer, variables);
        String processedBodyBuyer = MessageProcessingHelper.processVariables(bodyBuyer, variables);
        String processedSmsBuyer = MessageProcessingHelper.processVariables(smsBuyer, variables);
        SendMessageFromSystemDTO messageToBuyer = new SendMessageFromSystemDTO();
        messageToBuyer.setEntity(certification);
        messageToBuyer.setType(Message.Type.CERTIFICATION);
        messageToBuyer.setToMember(buyer);
        messageToBuyer.setSubject(processedSubjectBuyer);
        messageToBuyer.setBody(processedBodyBuyer);
        messageToBuyer.setSms(processedSmsBuyer);
        this.messageService.sendFromSystem(messageToBuyer);
        if (certification.getStatus() == Certification.Status.EXPIRED) {
            Member issuer = certification.getIssuer();
            String subjectIssuer = messageSettings.getExpiredCertificationSubject();
            String bodyIssuer = messageSettings.getExpiredCertificationMessage();
            String smsIssuer = messageSettings.getExpiredCertificationSms();
            String processedSubjectIssuer = MessageProcessingHelper.processVariables(subjectIssuer, certification, localSettings);
            String processedBodyIssuer = MessageProcessingHelper.processVariables(bodyIssuer, certification, localSettings);
            String processedSmsIssuer = MessageProcessingHelper.processVariables(smsIssuer, certification, localSettings);
            SendMessageFromSystemDTO messageToIssuer = new SendMessageFromSystemDTO();
            messageToIssuer.setEntity(certification);
            messageToIssuer.setType(Message.Type.CERTIFICATION);
            messageToIssuer.setToMember(issuer);
            messageToIssuer.setSubject(processedSubjectIssuer);
            messageToIssuer.setBody(processedBodyIssuer);
            messageToIssuer.setSms(processedSmsIssuer);
            this.messageService.sendFromSystem(messageToIssuer);
        }
    }

    @Override
    public void commissionContractAcceptedNotification(BrokerCommissionContract brokerCommissionContract) {
        Member destinationMember = brokerCommissionContract.getBrokering().getBroker();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getCommissionContractAcceptedSubject();
        String body = messageSettings.getCommissionContractAcceptedMessage();
        String sms = messageSettings.getCommissionContractAcceptedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, brokerCommissionContract, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, brokerCommissionContract, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, brokerCommissionContract, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(brokerCommissionContract);
        message.setType(Message.Type.BROKERING);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void commissionContractCancelledNotification(BrokerCommissionContract brokerCommissionContract) {
        Member destinationMember = brokerCommissionContract.getBrokering().getBrokered();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getCommissionContractCancelledSubject();
        String body = messageSettings.getCommissionContractCancelledMessage();
        String sms = messageSettings.getCommissionContractCancelledSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, brokerCommissionContract, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, brokerCommissionContract, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, brokerCommissionContract, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(brokerCommissionContract);
        message.setType(Message.Type.BROKERING);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void commissionContractDeniedNotification(BrokerCommissionContract brokerCommissionContract) {
        Member destinationMember = brokerCommissionContract.getBrokering().getBroker();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getCommissionContractDeniedSubject();
        String body = messageSettings.getCommissionContractDeniedMessage();
        String sms = messageSettings.getCommissionContractDeniedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, brokerCommissionContract, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, brokerCommissionContract, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, brokerCommissionContract, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(brokerCommissionContract);
        message.setType(Message.Type.BROKERING);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void deniedInvoiceNotification(Invoice invoice) {
        if (!invoice.isFromSystem()) {
            Member destinationMember = invoice.getFromMember();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            String subject = messageSettings.getInvoiceDeniedSubject();
            String body = messageSettings.getInvoiceDeniedMessage();
            String sms = messageSettings.getInvoiceDeniedSms();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, invoice.getTo(), invoice);
            String processedBody = MessageProcessingHelper.processVariables(body, localSettings, invoice.getTo(), invoice);
            String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, invoice.getTo(), invoice);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.INVOICE);
            message.setEntity(invoice);
            message.setToMember(destinationMember);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void expiredAdNotification(Ad ad) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getAdExpirationSubject();
        String body = messageSettings.getAdExpirationMessage();
        String sms = messageSettings.getAdExpirationSms();
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.AD_EXPIRATION);
        Member owner = ad.getOwner();
        message.setToMember(owner);
        String processedSubject = MessageProcessingHelper.processVariables(subject, ad, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, ad, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, ad, localSettings);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        message.setEntity(ad);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void expiredBrokeringNotification(Brokering brokering) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getBrokeringExpirationSubject();
        String body = messageSettings.getBrokeringExpirationMessage();
        String sms = messageSettings.getBrokeringExpirationSms();
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.BROKERING);
        Member broker = brokering.getBroker();
        message.setToMember(broker);
        Member member = brokering.getBrokered();
        String processedSubject = MessageProcessingHelper.processVariables(subject, member, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, member, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, member, localSettings);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void expiredInvoiceNotification(Invoice invoice) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (!invoice.isFromSystem()) {
            String subjectSender = messageSettings.getSentInvoiceExpiredSubject();
            String bodySender = messageSettings.getSentInvoiceExpiredMessage();
            String smsSender = messageSettings.getSentInvoiceExpiredSms();
            String processedSubjectSender = MessageProcessingHelper.processVariables(subjectSender, localSettings, invoice.getTo(), invoice);
            String processedBodySender = MessageProcessingHelper.processVariables(bodySender, localSettings, invoice.getTo(), invoice);
            String processedSmsSender = MessageProcessingHelper.processVariables(smsSender, localSettings, invoice.getTo(), invoice);
            SendMessageFromSystemDTO messageSender = new SendMessageFromSystemDTO();
            messageSender.setType(Message.Type.INVOICE);
            messageSender.setEntity(invoice);
            messageSender.setToMember(invoice.getFromMember());
            messageSender.setSubject(processedSubjectSender);
            messageSender.setBody(processedBodySender);
            messageSender.setSms(processedSmsSender);
            this.messageService.sendFromSystem(messageSender);
        }
        if (!invoice.isToSystem()) {
            String subjectReceiver = messageSettings.getReceivedInvoiceExpiredSubject();
            String bodyReceiver = messageSettings.getReceivedInvoiceExpiredMessage();
            String smsReceiver = messageSettings.getReceivedInvoiceExpiredSms();
            String processedSubjectReceiver = MessageProcessingHelper.processVariables(subjectReceiver, localSettings, invoice.getFrom(), invoice);
            String processedBodyReceiver = MessageProcessingHelper.processVariables(bodyReceiver, localSettings, invoice.getFrom(), invoice);
            String processedSmsReceiver = MessageProcessingHelper.processVariables(smsReceiver, localSettings, invoice.getFrom(), invoice);
            SendMessageFromSystemDTO messageReceiver = new SendMessageFromSystemDTO();
            messageReceiver.setType(Message.Type.INVOICE);
            messageReceiver.setEntity(invoice);
            messageReceiver.setToMember(invoice.getToMember());
            messageReceiver.setSubject(processedSubjectReceiver);
            messageReceiver.setBody(processedBodyReceiver);
            messageReceiver.setSms(processedSmsReceiver);
            this.messageService.sendFromSystem(messageReceiver);
        }
    }

    @Override
    public void expiredLoanNotification(LoanPayment payment) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getLoanExpirationSubject();
        String body = messageSettings.getLoanExpirationMessage();
        String sms = messageSettings.getLoanExpirationSms();
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.LOAN);
        Loan loan = payment.getLoan();
        message.setEntity(loan);
        Member member = (Member)loan.getTransfer().getTo().getOwner();
        message.setToMember(member);
        String processedSubject = MessageProcessingHelper.processVariables(subject, loan, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, loan, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, loan, localSettings);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void externalChannelPaymentConfirmed(PaymentRequestTicket ticket) {
        this.externalChannelPaymentNotification(ticket.getTransfer(), ticket.getFromChannel(), ticket.getToChannel());
    }

    @Override
    public void externalChannelPaymentPerformed(DoPaymentDTO dto, Payment payment) {
        String channelInternalName = dto.getChannel();
        Channel channel = this.channelService.loadByInternalName(channelInternalName);
        this.externalChannelPaymentNotification(payment, channel, null);
    }

    @Override
    public void externalChannelPaymentRequestExpired(PaymentRequestTicket ticket) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        Channel smsChannel = this.channelService.getSmsChannel();
        Channel toChannel = ticket.getToChannel();
        boolean skipToSms = toChannel.equals(smsChannel);
        Map<String, Object> toVariables = ticket.getVariableValues(localSettings);
        toVariables.put("channel", toChannel.getDisplayName());
        Member payer = ticket.getFrom();
        String subjectPayer = messageSettings.getExternalChannelPaymentRequestExpiredPayerSubject();
        String bodyPayer = messageSettings.getExternalChannelPaymentRequestExpiredPayerMessage();
        String smsPayer = skipToSms ? null : messageSettings.getExternalChannelPaymentRequestExpiredPayerSms();
        String processedSubjectPayer = MessageProcessingHelper.processVariables(subjectPayer, toVariables);
        String processedBodyPayer = MessageProcessingHelper.processVariables(bodyPayer, toVariables);
        String processedSmsPayer = smsPayer == null ? null : MessageProcessingHelper.processVariables(smsPayer, toVariables);
        SendMessageFromSystemDTO messageToPayer = new SendMessageFromSystemDTO();
        messageToPayer.setToMember(payer);
        messageToPayer.setType(Message.Type.EXTERNAL_PAYMENT);
        messageToPayer.setSubject(processedSubjectPayer);
        messageToPayer.setBody(processedBodyPayer);
        messageToPayer.setSms(processedSmsPayer);
        this.messageService.sendFromSystem(messageToPayer);
        Channel fromChannel = ticket.getFromChannel();
        boolean skipFromSms = fromChannel.equals(smsChannel);
        Map<String, Object> variableValues = ticket.getVariableValues(localSettings);
        variableValues.put("channel", fromChannel.getDisplayName());
        Member receiver = ticket.getTo();
        String subjectReceiver = messageSettings.getExternalChannelPaymentRequestExpiredReceiverSubject();
        String bodyReceiver = messageSettings.getExternalChannelPaymentRequestExpiredReceiverMessage();
        String smsReceiver = skipFromSms ? null : messageSettings.getExternalChannelPaymentRequestExpiredReceiverSms();
        String processedSubjectReceiver = MessageProcessingHelper.processVariables(subjectReceiver, variableValues);
        String processedBodyReceiver = MessageProcessingHelper.processVariables(bodyReceiver, variableValues);
        String processedSmsReceiver = smsReceiver == null ? null : MessageProcessingHelper.processVariables(smsReceiver, variableValues);
        SendMessageFromSystemDTO messageToReceiver = new SendMessageFromSystemDTO();
        messageToReceiver.setToMember(receiver);
        messageToReceiver.setType(Message.Type.PAYMENT);
        messageToReceiver.setSubject(processedSubjectReceiver);
        messageToReceiver.setBody(processedBodyReceiver);
        messageToReceiver.setSms(processedSmsReceiver);
        this.messageService.sendFromSystem(messageToReceiver);
    }

    @Override
    public void grantedLoanNotification(Loan loan) {
        if (loan.getTransfer().getProcessDate() == null) {
            return;
        }
        Member destinationMember = loan.getMember();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getLoanGrantedSubject();
        String body = messageSettings.getLoanGrantedMessage();
        String sms = messageSettings.getLoanGrantedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)destinationMember, loan);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)destinationMember, loan);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)destinationMember, loan);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.LOAN);
        message.setEntity(loan);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void guaranteeAcceptedNotification(Guarantee guarantee) {
        this.doGuaranteeStatusChangedNotification(guarantee, null);
    }

    @Override
    public void guaranteeCancelledNotification(Guarantee guarantee) {
        this.doGuaranteeStatusChangedNotification(guarantee, null);
    }

    @Override
    public void guaranteeDeniedNotification(Guarantee guarantee) {
        this.doGuaranteeStatusChangedNotification(guarantee, null);
    }

    @Override
    public void guaranteePendingIssuerNotification(Guarantee guarantee) {
        if (guarantee.getStatus() == Guarantee.Status.PENDING_ISSUER) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            Member toMember = guarantee.getIssuer();
            String subject = null;
            String body = null;
            String sms = null;
            if (guarantee.getGuaranteeType().getModel() == GuaranteeType.Model.WITH_BUYER_ONLY) {
                subject = messageSettings.getPendingBuyerOnlyGuaranteeIssuerSubject();
                body = messageSettings.getPendingBuyerOnlyGuaranteeIssuerMessage();
                sms = messageSettings.getPendingBuyerOnlyGuaranteeIssuerSms();
            } else {
                subject = messageSettings.getPendingGuaranteeIssuerSubject();
                body = messageSettings.getPendingGuaranteeIssuerMessage();
                sms = messageSettings.getPendingGuaranteeIssuerSms();
            }
            String processedSubject = MessageProcessingHelper.processVariables(subject, guarantee, localSettings);
            String processedBody = MessageProcessingHelper.processVariables(body, guarantee, localSettings);
            String processedSms = MessageProcessingHelper.processVariables(sms, guarantee, localSettings);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setEntity(guarantee);
            message.setType(Message.Type.GUARANTEE);
            message.setToMember(toMember);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void guaranteeStatusChangedNotification(Guarantee guarantee, Guarantee.Status prevStatus) {
        this.doGuaranteeStatusChangedNotification(guarantee, prevStatus);
    }

    @Override
    public void newCommissionContractNotification(BrokerCommissionContract brokerCommissionContract) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getNewCommissionContractSubject();
        String body = messageSettings.getNewCommissionContractMessage();
        String sms = messageSettings.getNewCommissionContractSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, brokerCommissionContract, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, brokerCommissionContract, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, brokerCommissionContract, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(brokerCommissionContract);
        message.setType(Message.Type.BROKERING);
        message.setToMember(brokerCommissionContract.getBrokering().getBrokered());
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void paymentAuthorizedOrDeniedNotification(Transfer transfer, boolean notifyTransactionFeedbackRequest) {
        boolean loggedAsReceiver;
        boolean loggedAsPayer;
        if (CollectionUtils.isEmpty((transfer = this.fetchService.reload(transfer, Transfer.Relationships.AUTHORIZATIONS)).getAuthorizations())) {
            return;
        }
        AccountOwner fromOwner = transfer.getFromOwner();
        AccountOwner toOwner = transfer.getToOwner();
        ArrayList<Member> sendMessageTo = new ArrayList<Member>();
        boolean bl = loggedAsPayer = LoggedUser.hasUser() && LoggedUser.isMember() && LoggedUser.accountOwner().equals(fromOwner);
        if (!loggedAsPayer && fromOwner instanceof Member) {
            sendMessageTo.add((Member)fromOwner);
        }
        boolean bl2 = loggedAsReceiver = LoggedUser.hasUser() && LoggedUser.isMember() && LoggedUser.accountOwner().equals(toOwner);
        if (!loggedAsReceiver && toOwner instanceof Member) {
            sendMessageTo.add((Member)toOwner);
        }
        if (!sendMessageTo.isEmpty()) {
            String sms2;
            String body2;
            String subject2;
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            switch (transfer.getStatus()) {
                case PROCESSED: {
                    subject2 = messageSettings.getPendingPaymentAuthorizedSubject();
                    body2 = messageSettings.getPendingPaymentAuthorizedMessage();
                    sms2 = messageSettings.getPendingPaymentAuthorizedSms();
                    break;
                }
                case PENDING: {
                    if (fromOwner instanceof Member) {
                        AuthorizationLevel.Authorizer authorizer = transfer.getNextAuthorizationLevel().getAuthorizer();
                        LocalSettings localSettings = this.settingsService.getLocalSettings();
                        switch (authorizer) {
                            case ADMIN: {
                                this.adminNotificationHandler.notifyNewPendingPayment(transfer);
                                break;
                            }
                            case BROKER: {
                                Member fromMember = this.fetchService.fetch((Member)fromOwner, Member.Relationships.BROKER);
                                Member broker = fromMember.getBroker();
                                if (broker == null) break;
                                String subject2 = messageSettings.getNewPendingPaymentByBrokerSubject();
                                String body2 = messageSettings.getNewPendingPaymentByBrokerMessage();
                                String sms2 = messageSettings.getNewPendingPaymentByBrokerSms();
                                String processedSubject = MessageProcessingHelper.processVariables(subject2, localSettings, (AccountOwner)fromMember, transfer);
                                String processedBody = MessageProcessingHelper.processVariables(body2, localSettings, (AccountOwner)fromMember, transfer);
                                String processedSms = MessageProcessingHelper.processVariables(sms2, localSettings, (AccountOwner)fromMember, transfer);
                                SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
                                message.setType(Message.Type.BROKERING);
                                message.setEntity(transfer);
                                message.setToMember(broker);
                                message.setSubject(processedSubject);
                                message.setBody(processedBody);
                                message.setSms(processedSms);
                                this.messageService.sendFromSystem(message);
                                break;
                            }
                            case PAYER: {
                                Member fromMember = (Member)fromOwner;
                                Member toMember = (Member)toOwner;
                                String subject2 = messageSettings.getNewPendingPaymentByPayerSubject();
                                String body2 = messageSettings.getNewPendingPaymentByPayerMessage();
                                String sms2 = messageSettings.getNewPendingPaymentByPayerSms();
                                String processedSubject = MessageProcessingHelper.processVariables(subject2, localSettings, (AccountOwner)toMember, transfer);
                                String processedBody = MessageProcessingHelper.processVariables(body2, localSettings, (AccountOwner)toMember, transfer);
                                String processedSms = MessageProcessingHelper.processVariables(sms2, localSettings, (AccountOwner)toMember, transfer);
                                SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
                                message.setType(Message.Type.PAYMENT);
                                message.setEntity(transfer);
                                message.setToMember(fromMember);
                                message.setSubject(processedSubject);
                                message.setBody(processedBody);
                                message.setSms(processedSms);
                                this.messageService.sendFromSystem(message);
                                break;
                            }
                        }
                    }
                    return;
                }
                case DENIED: {
                    subject2 = messageSettings.getPendingPaymentDeniedSubject();
                    body2 = messageSettings.getPendingPaymentDeniedMessage();
                    sms2 = messageSettings.getPendingPaymentDeniedSms();
                    break;
                }
                default: {
                    return;
                }
            }
            this.sendPaymentMessages(transfer, sendMessageTo, subject2, body2, sms2);
        }
        if (notifyTransactionFeedbackRequest) {
            this.notifyTransactionFeedbackRequest(transfer);
        }
    }

    @Override
    public void paymentCancelledNotification(Transfer transfer) {
        AccountOwner fromOwner = transfer.getFromOwner();
        AccountOwner toOwner = transfer.getToOwner();
        boolean loggedAsSender = LoggedUser.hasUser() && LoggedUser.isMember() && LoggedUser.accountOwner().equals(fromOwner);
        ArrayList<Member> sendMessageTo = new ArrayList<Member>();
        if (!loggedAsSender && fromOwner instanceof Member) {
            sendMessageTo.add((Member)fromOwner);
        }
        if (toOwner instanceof Member) {
            sendMessageTo.add((Member)toOwner);
        }
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getPendingPaymentCanceledSubject();
        String body = messageSettings.getPendingPaymentCanceledMessage();
        String sms = messageSettings.getPendingPaymentCanceledSms();
        this.sendPaymentMessages(transfer, sendMessageTo, subject, body, sms);
    }

    @Override
    public void paymentObligationPublishedNotification(PaymentObligation paymentObligation) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        Member toMember = paymentObligation.getSeller();
        String subject = messageSettings.getPaymentObligationRegisteredSubject();
        String body = messageSettings.getPaymentObligationRegisteredMessage();
        String sms = messageSettings.getPaymentObligationRegisteredSms();
        String processedSubject = MessageProcessingHelper.processVariables(subject, paymentObligation, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, paymentObligation, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, paymentObligation, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(paymentObligation);
        message.setType(Message.Type.PAYMENT_OBLIGATION);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        message.setToMember(toMember);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void paymentObligationRejectedNotification(PaymentObligation paymentObligation) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        Member toMember = paymentObligation.getBuyer();
        String subject = messageSettings.getPaymentObligationRejectedSubject();
        String body = messageSettings.getPaymentObligationRejectedMessage();
        String sms = messageSettings.getPaymentObligationRejectedSms();
        String processedSubject = MessageProcessingHelper.processVariables(subject, paymentObligation, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, paymentObligation, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, paymentObligation, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setEntity(paymentObligation);
        message.setType(Message.Type.PAYMENT_OBLIGATION);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        message.setToMember(toMember);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void paymentReceivedNotification(Payment payment) {
        if (payment instanceof Transfer && payment.getToOwner() instanceof Member) {
            Member broker;
            String sms;
            String body;
            String subject;
            Transfer transfer = (Transfer)payment;
            if (!transfer.isRoot()) {
                return;
            }
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            AuthorizationLevel nextAuthorizationLevel = transfer.getNextAuthorizationLevel();
            AuthorizationLevel.Authorizer authorizer = nextAuthorizationLevel == null ? null : nextAuthorizationLevel.getAuthorizer();
            Member destinationMember = (Member)payment.getToOwner();
            Set<MessageChannel> channels = this.preferenceService.receivedChannels(destinationMember, Message.Type.PAYMENT);
            if (!channels.isEmpty()) {
                boolean sendSmsNotification = transfer.getType().isAllowSmsNotification() && channels.contains((Object)MessageChannel.SMS);
                AccountStatus status = null;
                if (sendSmsNotification) {
                    status = this.accountService.getCurrentStatus(new AccountDTO(transfer.getTo()));
                }
                subject = null;
                body = null;
                sms = null;
                if (transfer.getProcessDate() == null) {
                    if (authorizer == AuthorizationLevel.Authorizer.RECEIVER) {
                        subject = messageSettings.getNewPendingPaymentByReceiverSubject();
                        body = messageSettings.getNewPendingPaymentByReceiverMessage();
                        if (sendSmsNotification) {
                            sms = messageSettings.getNewPendingPaymentByReceiverSms();
                        }
                    } else {
                        subject = messageSettings.getPendingPaymentReceivedSubject();
                        body = messageSettings.getPendingPaymentReceivedMessage();
                        if (sendSmsNotification) {
                            sms = messageSettings.getPendingPaymentReceivedSms();
                        }
                    }
                } else {
                    subject = messageSettings.getPaymentReceivedSubject();
                    body = messageSettings.getPaymentReceivedMessage();
                    if (sendSmsNotification) {
                        sms = messageSettings.getPaymentReceivedSms();
                    }
                }
                AccountOwner fromAccountOwner = payment.getFromOwner();
                String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, fromAccountOwner, payment);
                String processedBody = MessageProcessingHelper.processVariables(body, localSettings, fromAccountOwner, payment);
                String processedSms = sendSmsNotification ? MessageProcessingHelper.processVariables(sms, localSettings, fromAccountOwner, status, payment) : null;
                SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
                message.setType(Message.Type.PAYMENT);
                message.setEntity(payment);
                message.setToMember(destinationMember);
                message.setSubject(processedSubject);
                message.setBody(processedBody);
                message.setSms(processedSms);
                message.setSmsTraceData(transfer.getTraceData());
                this.messageService.sendFromSystem(message);
            }
            Member fromMember = this.fetchService.fetch(payment.isFromSystem() ? null : (Member)payment.getFromOwner(), Member.Relationships.BROKER);
            Member member = broker = fromMember == null ? null : fromMember.getBroker();
            if (authorizer == AuthorizationLevel.Authorizer.BROKER && broker != null) {
                subject = messageSettings.getNewPendingPaymentByBrokerSubject();
                body = messageSettings.getNewPendingPaymentByBrokerMessage();
                sms = messageSettings.getNewPendingPaymentByBrokerSms();
                String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)fromMember, payment);
                String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)fromMember, payment);
                String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)fromMember, payment);
                SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
                message.setType(Message.Type.BROKERING);
                message.setEntity(payment);
                message.setToMember(broker);
                message.setSubject(processedSubject);
                message.setBody(processedBody);
                message.setSms(processedSms);
                this.messageService.sendFromSystem(message);
            }
        }
        this.notifyTransactionFeedbackRequest(payment);
        this.notifyLowUnits(payment);
    }

    @Override
    public void posPinBlockedNotification(MemberPos memberPos) {
        Member member = memberPos.getMember();
        Pos pos = memberPos.getPos();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getPosPinBlockedSubject();
        String body = messageSettings.getPosPinBlockedMessage();
        String sms = messageSettings.getPosPinBlockedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, pos, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, pos, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, pos, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.ACCESS);
        message.setToMember(member);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void receivedInvoiceNotification(Invoice invoice) {
        Member destinationMember = invoice.getToMember();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getInvoiceReceivedSubject();
        String body = messageSettings.getInvoiceReceivedMessage();
        String sms = messageSettings.getInvoiceReceivedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, invoice.getFrom(), invoice);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, invoice.getFrom(), invoice);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, invoice.getFrom(), invoice);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.INVOICE);
        message.setEntity(invoice);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void receivedReferenceNotification(Reference reference) {
        Member destinationMember = reference.getTo();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getReferenceReceivedSubject();
        String body = messageSettings.getReferenceReceivedMessage();
        String sms = messageSettings.getReferenceReceivedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Member fromMember = reference.getFrom();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)fromMember, reference);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)fromMember, reference);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)fromMember, reference);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.REFERENCE);
        message.setEntity(reference);
        message.setToMember(destinationMember);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void removedBrokeringNotification(ChangeBrokerDTO dto) {
        boolean justSuspendCommission;
        Member member = this.fetchService.fetch(dto.getMember(), new Relationship[0]);
        Brokering oldBrokering = this.brokeringService.getActiveBrokering(member);
        Member oldBroker = oldBrokering == null ? null : oldBrokering.getBroker();
        Member newBroker = dto.getNewBroker();
        boolean bl = justSuspendCommission = oldBroker != null && oldBroker.equals(newBroker) && dto.isSuspendCommission();
        if (!justSuspendCommission && oldBroker != null) {
            MessageSettings messageSettings = this.settingsService.getMessageSettings();
            String subject = messageSettings.getBrokeringRemovedSubject();
            String body = messageSettings.getBrokeringRemovedMessage();
            String sms = messageSettings.getBrokeringRemovedSms();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            String processedSubject = MessageProcessingHelper.processVariables(subject, member, localSettings);
            String processedBody = MessageProcessingHelper.processVariables(body, member, localSettings);
            String processedSms = MessageProcessingHelper.processVariables(sms, member, localSettings);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.BROKERING);
            message.setToMember(oldBroker);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    @Override
    public void removedFromBrokerGroupNotification(Member member) {
        Group group = member.getGroup();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getRemovedFromBrokerGroupSubject();
        String body = messageSettings.getRemovedFromBrokerGroupMessage();
        String sms = messageSettings.getRemovedFromBrokerGroupSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, group, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, group, localSettings);
        String processedSms = MessageProcessingHelper.processVariables(sms, group, localSettings);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.BROKERING);
        message.setToMember(member);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void scheduledPaymentProcessingNotification(Transfer transfer, boolean notifyPayer, boolean notifyReceiver) {
        this.notifyScheduledPaymentProcessing(transfer, notifyPayer, notifyReceiver);
    }

    @Override
    public void scheduledPaymentsCancelledNotification(Member member, boolean notifyMember, Set<Member> membersToNotify, Set<MemberAccountType> removedAccounts) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.putAll(member.getVariableValues(localSettings));
        String processedSubject = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledToOtherSubject(), context);
        String processedBody = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledToOtherMessage(), context);
        String processedSms = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledToOtherSms(), context);
        for (Member m : membersToNotify) {
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.PAYMENT);
            message.setToMember(m);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
        if (notifyMember) {
            context.put("accounts", this.getAccountNames(removedAccounts));
            processedSubject = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledSubject(), context);
            processedBody = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledMessage(), context);
            processedSms = MessageProcessingHelper.processVariables(messageSettings.getScheduledPaymentsCancelledSms(), context);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.PAYMENT);
            message.setToMember(member);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    public void setCertificationServiceLocal(CertificationServiceLocal certificationService) {
        this.certificationService = certificationService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    public void setPreferenceServiceLocal(PreferenceServiceLocal preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void transactionFeedBackAdminCommentsNotification(TransactionFeedback transactionFeedback) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getTransactionFeedbackAdminCommentsSubject();
        String body = messageSettings.getTransactionFeedbackAdminCommentsMessage();
        String sms = messageSettings.getTransactionFeedbackAdminCommentsSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.TRANSACTION_FEEDBACK);
        message.setEntity(transactionFeedback);
        message.setToMember(transactionFeedback.getFrom());
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
        processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)transactionFeedback.getFrom(), transactionFeedback.getTransfer());
        processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)transactionFeedback.getFrom(), transactionFeedback.getTransfer());
        SendMessageFromSystemDTO message2 = new SendMessageFromSystemDTO();
        message2.setType(Message.Type.TRANSACTION_FEEDBACK);
        message2.setEntity(transactionFeedback);
        message2.setToMember(transactionFeedback.getTo());
        message2.setSubject(processedSubject);
        message2.setBody(processedBody);
        this.messageService.sendFromSystem(message2);
    }

    @Override
    public void transactionFeedBackReceivedNotification(TransactionFeedback transactionFeedback) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getTransactionFeedbackReceivedSubject();
        String body = messageSettings.getTransactionFeedbackReceivedMessage();
        String sms = messageSettings.getTransactionFeedbackReceivedSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, String> extraVariables = new HashMap<String, String>();
        Payment payment = transactionFeedback.getPayment();
        Calendar limit = payment.getType().getFeedbackReplyExpirationTime().add(Calendar.getInstance());
        extraVariables.put("limit", localSettings.getDateConverter().toString(limit));
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)transactionFeedback.getFrom(), payment);
        processedSubject = MessageProcessingHelper.processVariables(processedSubject, extraVariables);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)transactionFeedback.getFrom(), payment);
        processedBody = MessageProcessingHelper.processVariables(processedBody, extraVariables);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)transactionFeedback.getFrom(), payment);
        processedSms = MessageProcessingHelper.processVariables(processedSms, extraVariables);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.TRANSACTION_FEEDBACK);
        message.setEntity(transactionFeedback);
        message.setToMember(transactionFeedback.getTo());
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    @Override
    public void transactionFeedBackReplyNotification(TransactionFeedback transactionFeedback) {
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getTransactionFeedbackReplySubject();
        String body = messageSettings.getTransactionFeedbackReplyMessage();
        String sms = messageSettings.getTransactionFeedbackReplySms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)transactionFeedback.getTo(), transactionFeedback.getTransfer());
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.TRANSACTION_FEEDBACK);
        message.setEntity(transactionFeedback);
        message.setToMember(transactionFeedback.getFrom());
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    private void doGuaranteeStatusChangedNotification(Guarantee guarantee, Guarantee.Status prevStatus) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String statusString = this.messageResolver.message("guarantee.status." + guarantee.getStatus().toString(), new Object[0]);
        Map<String, Object> variables = guarantee.getVariableValues(localSettings);
        variables.put("status", statusString);
        Guarantee.Status newStatus = guarantee.getStatus();
        if (newStatus == Guarantee.Status.ACCEPTED || newStatus == Guarantee.Status.REJECTED || newStatus == Guarantee.Status.CANCELLED) {
            boolean buyerOnly = guarantee.getGuaranteeType().getModel() == GuaranteeType.Model.WITH_BUYER_ONLY;
            Member buyer = guarantee.getBuyer();
            Member seller = guarantee.getSeller();
            Member issuer = guarantee.getIssuer();
            String subject = null;
            String body = null;
            String sms = null;
            if (buyerOnly) {
                subject = messageSettings.getBuyerOnlyGuaranteeStatusChangedSubject();
                body = messageSettings.getBuyerOnlyGuaranteeStatusChangedMessage();
                sms = messageSettings.getBuyerOnlyGuaranteeStatusChangedSms();
            } else {
                subject = messageSettings.getGuaranteeStatusChangedSubject();
                body = messageSettings.getGuaranteeStatusChangedMessage();
                sms = messageSettings.getGuaranteeStatusChangedSms();
            }
            String processedSubject = MessageProcessingHelper.processVariables(subject, variables);
            String processedBody = MessageProcessingHelper.processVariables(body, variables);
            String processedSms = MessageProcessingHelper.processVariables(sms, variables);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setEntity(guarantee);
            message.setType(Message.Type.GUARANTEE);
            message.setToMember(buyer);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
            if (newStatus == Guarantee.Status.CANCELLED) {
                message.setToMember(issuer);
                message.setSubject(processedSubject);
                message.setBody(processedBody);
                this.messageService.sendFromSystem(message);
            }
            if (!buyerOnly) {
                message.setToMember(seller);
                message.setSubject(processedSubject);
                message.setBody(processedBody);
                this.messageService.sendFromSystem(message);
            }
        } else if (newStatus == Guarantee.Status.WITHOUT_ACTION && prevStatus == Guarantee.Status.PENDING_ISSUER) {
            Member issuer = guarantee.getIssuer();
            String subject = messageSettings.getExpiredGuaranteeSubject();
            String body = messageSettings.getExpiredGuaranteeMessage();
            String sms = messageSettings.getExpiredGuaranteeSms();
            String processedSubject = MessageProcessingHelper.processVariables(subject, variables);
            String processedBody = MessageProcessingHelper.processVariables(body, variables);
            String processedSms = MessageProcessingHelper.processVariables(sms, variables);
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setEntity(guarantee);
            message.setType(Message.Type.GUARANTEE);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setToMember(issuer);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }

    private synchronized void doSendLowUnitsNotification(MemberAccount account, MemberGroupAccountSettings mgas) {
        Member fromOwner = account.getOwner();
        Calendar lastLowUnitsSent = account.getLastLowUnitsSent();
        if (lastLowUnitsSent != null && DateHelper.decimalDaysBetween(lastLowUnitsSent, Calendar.getInstance()).doubleValue() < 1.0) {
            return;
        }
        AccountStatus status = this.accountService.getCurrentStatus(new AccountDTO(account));
        if (status.getAvailableBalance().compareTo(mgas.getLowUnits()) > 0) {
            return;
        }
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getLowUnitsSubject();
        String body = mgas.getLowUnitsMessage();
        if (StringUtils.isEmpty((String)body)) {
            body = messageSettings.getLowUnitsMessage();
        }
        String sms = messageSettings.getLowUnitsSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(fromOwner.getVariableValues(localSettings));
        variables.putAll(account.getVariableValues(localSettings));
        variables.putAll(status.getVariableValues(localSettings));
        String processedSubject = MessageProcessingHelper.processVariables(subject, variables);
        String processedBody = MessageProcessingHelper.processVariables(body, variables);
        String processedSms = MessageProcessingHelper.processVariables(sms, variables);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.ACCOUNT);
        message.setToMember(fromOwner);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
        account.setLastLowUnitsSent(Calendar.getInstance());
    }

    private void externalChannelPaymentNotification(Payment payment, Channel fromChannel, Channel toChannel) {
        Channel channelToCheckForReceiver;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        boolean isPaymentConfirmation = toChannel != null;
        Channel smsChannel = this.channelService.getSmsChannel();
        if (payment.getFromOwner() instanceof Member) {
            Channel channelToCheckForPayer = isPaymentConfirmation ? toChannel : fromChannel;
            boolean skipSms = channelToCheckForPayer != null && channelToCheckForPayer.equals(smsChannel);
            Member fromMember = (Member)payment.getFromOwner();
            String subject = messageSettings.getExternalChannelPaymentPerformedSubject();
            String body = messageSettings.getExternalChannelPaymentPerformedMessage();
            String sms = skipSms ? null : messageSettings.getExternalChannelPaymentPerformedSms();
            Map<String, Object> variableValues = payment.getVariableValues(localSettings);
            variableValues.put("channel", channelToCheckForPayer.getDisplayName());
            AccountOwner toOwner = payment.getToOwner();
            String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, toOwner, payment);
            processedSubject = MessageProcessingHelper.processVariables(processedSubject, variableValues);
            String processedBody = MessageProcessingHelper.processVariables(body, localSettings, toOwner, payment);
            processedBody = MessageProcessingHelper.processVariables(processedBody, variableValues);
            String processedSms = null;
            if (sms != null) {
                processedSms = MessageProcessingHelper.processVariables(sms, localSettings, toOwner, payment);
                processedSms = MessageProcessingHelper.processVariables(processedSms, variableValues);
            }
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setToMember(fromMember);
            message.setType(Message.Type.EXTERNAL_PAYMENT);
            message.setEntity(payment);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
        Channel channel = channelToCheckForReceiver = isPaymentConfirmation ? fromChannel : toChannel;
        if (channelToCheckForReceiver == null || !channelToCheckForReceiver.equals(smsChannel)) {
            this.paymentReceivedNotification(payment);
        }
    }

    private String getAccountNames(Set<MemberAccountType> removedAccounts) {
        StringBuilder str = new StringBuilder();
        for (MemberAccountType type : removedAccounts) {
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(type.getName());
        }
        return str.toString();
    }

    private void notifyLowUnits(Payment payment) {
        BigDecimal lowUnits;
        if (!(payment instanceof Transfer)) {
            return;
        }
        Account account = this.fetchService.fetch(payment.getFrom(), RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY), RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP));
        if (!(account instanceof MemberAccount)) {
            return;
        }
        MemberAccount memberAccount = (MemberAccount)account;
        Group group = memberAccount.getMember().getGroup();
        AccountType accountType = account.getType();
        MemberGroupAccountSettings mgas = this.groupService.loadAccountSettings(group.getId(), accountType.getId(), new Relationship[0]);
        BigDecimal bigDecimal = lowUnits = mgas.getLowUnits() == null ? BigDecimal.ZERO : mgas.getLowUnits();
        if (lowUnits.floatValue() > 1.0E-4f && StringUtils.isNotEmpty((String)mgas.getLowUnitsMessage())) {
            this.doSendLowUnitsNotification(memberAccount, mgas);
        }
    }

    private void notifyScheduledPaymentProcessing(Transfer transfer, boolean notifyPayer, boolean notifyReceiver) {
        Member broker;
        Set<MessageChannel> payeeChannels;
        Set<MessageChannel> payerChannels;
        String payeeSms;
        String payeeBody;
        String payeeSubject;
        String payerSms;
        String payerBody;
        String payerSubject;
        Member payer = transfer.isFromSystem() ? null : (Member)transfer.getFrom().getOwner();
        Member payee = transfer.isToSystem() ? null : (Member)transfer.getTo().getOwner();
        AuthorizationLevel nextAuthorizationLevel = transfer.getNextAuthorizationLevel();
        AuthorizationLevel.Authorizer authorizer = nextAuthorizationLevel == null ? null : nextAuthorizationLevel.getAuthorizer();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        switch (transfer.getStatus()) {
            case PROCESSED: {
                if (notifyPayer) {
                    payerSubject = messageSettings.getScheduledPaymentProcessedSubject();
                    payerBody = messageSettings.getScheduledPaymentProcessedMessage();
                    payerSms = messageSettings.getScheduledPaymentProcessedSms();
                } else {
                    payerSubject = null;
                    payerBody = null;
                    payerSms = null;
                }
                if (notifyReceiver) {
                    payeeSubject = messageSettings.getPaymentReceivedSubject();
                    payeeBody = messageSettings.getPaymentReceivedMessage();
                    payeeSms = messageSettings.getPaymentReceivedSms();
                    break;
                }
                payeeSubject = null;
                payeeBody = null;
                payeeSms = null;
                break;
            }
            case PENDING: {
                payerSubject = null;
                payerBody = null;
                payerSms = null;
                if (authorizer == AuthorizationLevel.Authorizer.RECEIVER) {
                    payeeSubject = messageSettings.getNewPendingPaymentByReceiverSubject();
                    payeeBody = messageSettings.getNewPendingPaymentByReceiverMessage();
                    payeeSms = messageSettings.getNewPendingPaymentByReceiverSms();
                    break;
                }
                payeeSubject = messageSettings.getPendingPaymentReceivedSubject();
                payeeBody = messageSettings.getPendingPaymentReceivedMessage();
                payeeSms = messageSettings.getPendingPaymentReceivedSms();
                break;
            }
            case FAILED: {
                payerSubject = messageSettings.getScheduledPaymentFailedToPayerSubject();
                payerBody = messageSettings.getScheduledPaymentFailedToPayerMessage();
                payerSms = messageSettings.getScheduledPaymentFailedToPayerSms();
                try {
                    boolean notify;
                    ScheduledPayment scheduledPayment = transfer.getScheduledPayment();
                    boolean bl = notify = scheduledPayment != null && scheduledPayment.isShowToReceiver();
                    if (!notify) {
                        this.invoiceService.loadByPayment(scheduledPayment == null ? transfer : scheduledPayment, new Relationship[0]);
                        notify = true;
                    }
                    if (notify) {
                        payeeSubject = messageSettings.getScheduledPaymentFailedToPayeeSubject();
                        payeeBody = messageSettings.getScheduledPaymentFailedToPayeeMessage();
                        payeeSms = messageSettings.getScheduledPaymentFailedToPayeeSms();
                        break;
                    }
                    payeeSubject = null;
                    payeeBody = null;
                    payeeSms = null;
                }
                catch (EntityNotFoundException e) {
                    payeeSubject = null;
                    payeeBody = null;
                    payeeSms = null;
                }
                break;
            }
            default: {
                return;
            }
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.PAYMENT);
        message.setEntity(transfer);
        Set<MessageChannel> set = payerChannels = payer == null || payerSubject == null ? null : this.preferenceService.receivedChannels(payer, Message.Type.PAYMENT);
        if (CollectionUtils.isNotEmpty(payerChannels)) {
            boolean sendSmsNotification;
            AccountStatus statusPayer = null;
            boolean bl = sendSmsNotification = transfer.getType().isAllowSmsNotification() && payerChannels.contains((Object)MessageChannel.SMS);
            if (sendSmsNotification) {
                statusPayer = this.accountService.getCurrentStatus(new AccountDTO(transfer.getFrom()));
            }
            AccountOwner payeeOwner = (AccountOwner)((Object)(payee == null ? SystemAccountOwner.instance() : payee));
            message.setToMember(payer);
            message.setSubject(MessageProcessingHelper.processVariables(payerSubject, localSettings, payeeOwner, transfer));
            message.setBody(MessageProcessingHelper.processVariables(payerBody, localSettings, payeeOwner, transfer));
            if (sendSmsNotification) {
                message.setSms(MessageProcessingHelper.processVariables(payerSms, localSettings, payeeOwner, statusPayer, transfer));
            }
            this.messageService.sendFromSystem(message);
        }
        Set<MessageChannel> set2 = payeeChannels = payee == null || payeeSubject == null ? null : this.preferenceService.receivedChannels(payee, Message.Type.PAYMENT);
        if (CollectionUtils.isNotEmpty(payeeChannels)) {
            boolean sendSmsNotification;
            AccountStatus statusPayee = null;
            boolean bl = sendSmsNotification = transfer.getType().isAllowSmsNotification() && payeeChannels.contains((Object)MessageChannel.SMS);
            if (sendSmsNotification) {
                statusPayee = this.accountService.getCurrentStatus(new GetTransactionsDTO(transfer.getTo()));
            }
            AccountOwner payerOwner = (AccountOwner)((Object)(payer == null ? SystemAccountOwner.instance() : payer));
            message.setToMember(payee);
            message.setSubject(MessageProcessingHelper.processVariables(payeeSubject, localSettings, payerOwner, transfer));
            message.setBody(MessageProcessingHelper.processVariables(payeeBody, localSettings, payerOwner, transfer));
            if (sendSmsNotification) {
                message.setSms(MessageProcessingHelper.processVariables(payeeSms, localSettings, payerOwner, statusPayee, transfer));
            }
            this.messageService.sendFromSystem(message);
        }
        Member member = broker = payer == null ? null : payer.getBroker();
        if (authorizer == AuthorizationLevel.Authorizer.BROKER && broker != null) {
            String subject = messageSettings.getNewPendingPaymentByBrokerSubject();
            String body = messageSettings.getNewPendingPaymentByBrokerMessage();
            String sms = messageSettings.getNewPendingPaymentByBrokerSms();
            message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.BROKERING);
            message.setEntity(transfer);
            message.setToMember(broker);
            message.setSubject(MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)payer, transfer));
            message.setBody(MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)payer, transfer));
            message.setSms(MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)payer, transfer));
            this.messageService.sendFromSystem(message);
        }
        this.notifyLowUnits(transfer);
    }

    private void notifyTransactionFeedbackRequest(Payment payment) {
        Transfer transfer;
        if ((payment = this.fetchService.fetch(payment, Payment.Relationships.FROM, Payment.Relationships.TO, Payment.Relationships.TYPE)) == null || payment.isFromSystem() || payment.isToSystem() || !payment.getType().isRequiresFeedback()) {
            return;
        }
        if (payment instanceof Transfer && (transfer = (Transfer)payment).getProcessDate() == null) {
            return;
        }
        Member from = (Member)payment.getFromOwner();
        Member to = (Member)payment.getToOwner();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = messageSettings.getTransactionFeedbackRequestSubject();
        String body = messageSettings.getTransactionFeedbackRequestMessage();
        String sms = messageSettings.getTransactionFeedbackRequestSms();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        HashMap<String, String> extraVariables = new HashMap<String, String>();
        Calendar limit = payment.getType().getFeedbackExpirationTime().add(Calendar.getInstance());
        extraVariables.put("limit", localSettings.getDateConverter().toString(limit));
        String processedSubject = MessageProcessingHelper.processVariables(subject, localSettings, (AccountOwner)to, payment);
        String processedBody = MessageProcessingHelper.processVariables(body, localSettings, (AccountOwner)to, payment);
        String processedSms = MessageProcessingHelper.processVariables(sms, localSettings, (AccountOwner)to, payment);
        processedSubject = MessageProcessingHelper.processVariables(processedSubject, extraVariables);
        processedBody = MessageProcessingHelper.processVariables(processedBody, extraVariables);
        processedSms = MessageProcessingHelper.processVariables(processedSms, extraVariables);
        SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
        message.setType(Message.Type.TRANSACTION_FEEDBACK);
        message.setEntity(new TransactionFeedbackRequest(payment));
        message.setToMember(from);
        message.setSubject(processedSubject);
        message.setBody(processedBody);
        message.setSms(processedSms);
        this.messageService.sendFromSystem(message);
    }

    private void sendPaymentMessages(Transfer transfer, List<Member> sendMessageTo, String subject, String body, String sms) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String processedSubject = MessageProcessingHelper.processVariables(subject, transfer, localSettings);
        String processedBody = MessageProcessingHelper.processVariables(body, transfer, localSettings);
        String processedSms = transfer.getType().isAllowSmsNotification() ? MessageProcessingHelper.processVariables(sms, transfer, localSettings) : null;
        for (Member member : sendMessageTo) {
            SendMessageFromSystemDTO message = new SendMessageFromSystemDTO();
            message.setType(Message.Type.PAYMENT);
            message.setEntity(transfer);
            message.setToMember(member);
            message.setSubject(processedSubject);
            message.setBody(processedBody);
            message.setSms(processedSms);
            this.messageService.sendFromSystem(message);
        }
    }
}

