/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.paymentrequest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentRequestHandler;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.WorkerThreads;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.webservices.external.ExternalWebServiceHelper;
import nl.strohalm.cyclos.webservices.external.paymentrequest.PaymentRequestWebService;
import nl.strohalm.cyclos.webservices.model.PaymentRequestTicketVO;
import nl.strohalm.cyclos.webservices.utils.TicketHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class PaymentRequestHandlerImpl
implements PaymentRequestHandler,
BeanFactoryAware,
DisposableBean {
    private TicketHelper ticketHelper;
    private SettingsServiceLocal settingsService;
    private TicketServiceLocal ticketService;
    private ErrorLogServiceLocal errorLogService;
    private ChannelServiceLocal channelService;
    private BeanFactory beanFactory;
    private boolean initialized;
    private PaymentRequestSenderThreads senderThreads;
    private int maxThreads = 5;
    private TransactionHelper transactionHelper;
    private final Map<String, PaymentRequestWebService> cachedProxies = new ConcurrentHashMap<String, PaymentRequestWebService>();

    public void destroy() throws Exception {
        if (this.senderThreads != null) {
            this.senderThreads.interrupt();
            this.senderThreads = null;
        }
    }

    @Override
    public void invalidateCache() {
        this.cachedProxies.clear();
    }

    @Override
    public void sendRequest(final PaymentRequestTicket ticket) {
        this.maybeInitialize();
        if (this.senderThreads == null) {
            return;
        }
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                PaymentRequestHandlerImpl.this.senderThreads.enqueue(ticket);
            }
        });
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    private synchronized void maybeInitialize() {
        if (!this.initialized) {
            this.settingsService = (SettingsServiceLocal)this.beanFactory.getBean(SettingsServiceLocal.class);
            this.ticketHelper = (TicketHelper)this.beanFactory.getBean(TicketHelper.class);
            this.errorLogService = (ErrorLogServiceLocal)this.beanFactory.getBean(ErrorLogServiceLocal.class);
            this.ticketService = (TicketServiceLocal)this.beanFactory.getBean(TicketServiceLocal.class);
            this.transactionHelper = (TransactionHelper)this.beanFactory.getBean(TransactionHelper.class);
            this.senderThreads = new PaymentRequestSenderThreads("Payment request sender for " + this.settingsService.getLocalSettings().getApplicationName(), this.maxThreads);
            this.initialized = true;
        }
    }

    private PaymentRequestWebService proxyFor(Channel channel) throws IOException {
        String url = StringUtils.trimToEmpty((String)channel.getPaymentRequestWebServiceUrl());
        PaymentRequestWebService proxy = this.cachedProxies.get(url);
        if (proxy == null) {
            proxy = url.isEmpty() ? new OfflineHandler() : ExternalWebServiceHelper.proxyFor(PaymentRequestWebService.class, url);
            this.cachedProxies.put(url, proxy);
        }
        return proxy;
    }

    private class PaymentRequestSenderThreads
    extends WorkerThreads<PaymentRequestTicket> {
        protected PaymentRequestSenderThreads(String name, int threadCount) {
            super(name, threadCount);
        }

        @Override
        protected void process(final PaymentRequestTicket t) {
            PaymentRequestHandlerImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    PaymentRequestTicket ticket = (PaymentRequestTicket)PaymentRequestHandlerImpl.this.ticketService.load(t.getTicket(), Ticket.Relationships.FROM, Ticket.Relationships.TO);
                    LocalSettings localSettings = PaymentRequestHandlerImpl.this.settingsService.getLocalSettings();
                    Channel channel = PaymentRequestHandlerImpl.this.channelService.load(ticket.getToChannel().getId());
                    try {
                        PaymentRequestWebService ws = PaymentRequestHandlerImpl.this.proxyFor(channel);
                        boolean result = ws.requestPayment(localSettings.getCyclosId(), PaymentRequestHandlerImpl.this.ticketHelper.toVO(ticket, channel.getPrincipalCustomFields()));
                        if (!result) {
                            throw new Exception("The PaymentRequestWebService returned an error status");
                        }
                    }
                    catch (Exception e) {
                        PaymentRequestHandlerImpl.this.ticketService.markAsFailedtoSend(ticket);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("ticket", ticket.getTicket());
                        params.put("payer username", ticket.getFrom().getUsername());
                        params.put("receiver username", ticket.getTo().getUsername());
                        PaymentRequestHandlerImpl.this.errorLogService.insert(e, channel.getPaymentRequestWebServiceUrl(), params);
                    }
                }
            });
        }
    }

    private static class OfflineHandler
    implements PaymentRequestWebService {
        private OfflineHandler() {
        }

        @Override
        public boolean requestPayment(String cyclosId, PaymentRequestTicketVO ticket) {
            return false;
        }
    }
}

