/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.query;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import nl.strohalm.cyclos.utils.query.Page;
import nl.strohalm.cyclos.utils.query.PageParameters;

public class PageImpl<E>
extends LinkedList<E>
implements Page<E> {
    private static final long serialVersionUID = 3721714371412617795L;
    private final int currentPage;
    private final int pageSize;
    private final int totalCount;

    private static <E> Collection<E> pageElements(PageParameters parameters, Collection<E> elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        int maxSize = parameters.getPageSize();
        if (elements.size() > maxSize) {
            LinkedList<E> col = new LinkedList<E>();
            int i = 0;
            for (E e : elements) {
                if (i == maxSize) break;
                col.add(e);
                ++i;
            }
            return col;
        }
        return elements;
    }

    public PageImpl(PageParameters parameters, int totalCount, Collection<E> elements) {
        super(PageImpl.pageElements(parameters, elements));
        this.pageSize = Math.max(1, parameters.getPageSize());
        this.totalCount = totalCount;
        this.currentPage = Math.max(0, Math.min(parameters.getCurrentPage(), this.getPageCount() - 1));
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int getCurrentPageSize() {
        return this.size();
    }

    @Override
    public int getPageCount() {
        return (int)Math.ceil((float)this.totalCount / (float)this.pageSize);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public boolean isLastPage() {
        return this.currentPage >= this.getPageCount() - 1;
    }
}

