/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.query;

import java.io.Serializable;

public class PageParameters
implements Serializable {
    private static final long serialVersionUID = 5377756881002779499L;
    private static final PageParameters UNIQUE = new PageParameters(1, 0);
    private static final PageParameters COUNT = new PageParameters(0, 0);
    private static final PageParameters ALL = new PageParameters(Integer.MAX_VALUE, 0);
    private int currentPage;
    private int pageSize;

    public static PageParameters all() {
        return ALL;
    }

    public static PageParameters count() {
        return COUNT;
    }

    public static PageParameters max(int results) {
        return new PageParameters(results, 0);
    }

    public static PageParameters unique() {
        return UNIQUE;
    }

    public PageParameters() {
    }

    public PageParameters(int pageSize, int currentPage) {
        this.setPageSize(pageSize);
        this.setCurrentPage(currentPage);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getFirstResult() {
        return this.currentPage * this.pageSize;
    }

    public int getMaxResults() {
        return this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = Math.max(0, currentPage);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = Math.max(0, pageSize);
    }

    public String toString() {
        return this.currentPage + " / " + this.pageSize;
    }
}

