/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.query.PageParameters;

public abstract class QueryParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -151092190863904194L;
    private Set<Relationship> fetch;
    private PageParameters pageParameters;
    private ResultType resultType = ResultType.LIST;

    public void clearFetch() {
        this.fetch = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void fetch(Relationship ... relationships) {
        if (this.fetch == null) {
            this.fetch = new LinkedHashSet<Relationship>();
        }
        if (relationships != null) {
            this.fetch.addAll(Arrays.asList(relationships));
        }
    }

    public Set<Relationship> getFetch() {
        return this.fetch;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public boolean isPaged() {
        return this.pageParameters != null && this.resultType == ResultType.PAGE;
    }

    public void limitResults(int maxResults) {
        this.pageParameters = new PageParameters(maxResults, 0);
    }

    public void setFetch(Set<Relationship> fetch) {
        this.fetch = fetch;
    }

    public void setIterateAll() {
        this.setResultType(ResultType.ITERATOR);
        this.setPageParameters(PageParameters.all());
    }

    public void setPageForCount() {
        this.setResultType(ResultType.PAGE);
        this.setPageParameters(PageParameters.count());
    }

    public void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType == null ? ResultType.LIST : resultType;
    }

    public void setUniqueResult() {
        this.setResultType(ResultType.LIST);
        this.setPageParameters(PageParameters.unique());
    }

    public String toString() {
        return FormatObject.formatVO(this, "fetch", "pageParameters", "paged");
    }

    public static enum ResultType {
        LIST,
        PAGE,
        ITERATOR;

    }
}

