/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.sms;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.sms.SmsMailingServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.sms.SmsSender;
import nl.strohalm.cyclos.webservices.external.ExternalWebServiceHelper;
import nl.strohalm.cyclos.webservices.external.sms.SendSmsSenderParameters;
import nl.strohalm.cyclos.webservices.external.sms.SmsSenderWebService;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class SmsSenderImpl
implements SmsSender,
LocalSettingsChangeListener,
BeanFactoryAware {
    private boolean initialized;
    private BeanFactory beanFactory;
    private SmsSenderWebService smsWebService;
    private ElementServiceLocal elementService;
    private ErrorLogServiceLocal errorLogService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private MemberHelper memberHelper;
    private SettingsServiceLocal settingsService;
    private ChannelServiceLocal channelService;
    private SmsMailingServiceLocal smsMailingService;
    private CustomFieldHelper customFieldHelper;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.smsWebService = null;
    }

    @Override
    public boolean send(Member member, String text, String traceData) {
        this.maybeInitialize();
        Channel smsChannel = this.channelService.getSmsChannel();
        if (smsChannel == null) {
            IllegalStateException e = new IllegalStateException("No channel was set on Local Settings as SMS channel");
            this.logError(member, text, e);
            return false;
        }
        MemberCustomField smsCustomField = this.settingsService.getSmsCustomField();
        if (smsCustomField == null) {
            IllegalStateException e = new IllegalStateException("No custom field was set on Local Settings as SMS field");
            this.logError(member, text, e);
            return false;
        }
        Set<MemberCustomField> requiredCustomFields = smsChannel.getPrincipalCustomFields();
        requiredCustomFields.add(smsCustomField);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String cyclosId = localSettings.getCyclosId();
        member = (Member)this.elementService.load(member.getId(), Element.Relationships.GROUP);
        List<MemberCustomField> memberCustomFields = this.memberCustomFieldService.list();
        List<MemberCustomField> customFields = this.customFieldHelper.onlyForGroup(memberCustomFields, member.getMemberGroup());
        customFields = this.customFieldHelper.onlyBasic(memberCustomFields);
        MemberVO memberVO = this.memberHelper.toVO(member, customFields, requiredCustomFields, false);
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String prefix = messageSettings.getSmsMessagePrefix();
        Map<String, String> variables = this.smsMailingService.getSmsTextVariables(null, member, false);
        prefix = StringUtils.trimToEmpty((String)MessageProcessingHelper.processVariables(prefix, variables));
        text = StringUtils.trimToEmpty((String)MessageProcessingHelper.processVariables(text, variables));
        text = StringUtils.trimToEmpty((String)(prefix + " " + text));
        try {
            SendSmsSenderParameters params = new SendSmsSenderParameters();
            params.setMember(memberVO);
            params.setText(text);
            params.setTraceData(traceData);
            return this.getSmsWebService().send(cyclosId, params);
        }
        catch (Exception e) {
            this.logError(member, text, e);
            return false;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setSmsMailingServiceLocal(SmsMailingServiceLocal smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    private SmsSenderWebService getSmsWebService() throws IOException {
        if (this.smsWebService == null) {
            String url = this.settingsService.getLocalSettings().getSendSmsWebServiceUrl();
            this.smsWebService = StringUtils.isEmpty((String)url) ? new VoidSender() : ExternalWebServiceHelper.proxyFor(SmsSenderWebService.class, url);
        }
        return this.smsWebService;
    }

    private void logError(Member member, String sms, Exception e) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", member.getUsername());
        params.put("name", member.getName());
        params.put("sms", sms);
        this.errorLogService.insert(e, this.settingsService.getLocalSettings().getSendSmsWebServiceUrl(), params);
    }

    private synchronized void maybeInitialize() {
        if (!this.initialized) {
            this.settingsService = (SettingsServiceLocal)this.beanFactory.getBean(SettingsServiceLocal.class);
            this.settingsService.addListener(this);
            this.memberCustomFieldService = (MemberCustomFieldServiceLocal)this.beanFactory.getBean(MemberCustomFieldServiceLocal.class);
            this.elementService = (ElementServiceLocal)this.beanFactory.getBean(ElementServiceLocal.class);
            this.memberHelper = (MemberHelper)this.beanFactory.getBean(MemberHelper.class);
            this.errorLogService = (ErrorLogServiceLocal)this.beanFactory.getBean(ErrorLogServiceLocal.class);
            this.initialized = true;
        }
    }

    private static class VoidSender
    implements SmsSenderWebService {
        private VoidSender() {
        }

        @Override
        public boolean send(String cyclosId, SendSmsSenderParameters params) {
            return false;
        }
    }
}

