/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.statistics;

import java.util.ArrayList;

public class GraphHelper {
    private static final int MAX_X_RANGE_VALUE = 24;
    private static final int MIN_X_RANGE_VALUE = 8;
    private static final double[] FACTORS = new double[]{1.0, 2.0, 5.0};

    public static Number[] getAxisCategories(Number start, Number end) {
        double difference;
        double highest = Math.max(start.doubleValue(), end.doubleValue());
        double lowest = Math.min(start.doubleValue(), end.doubleValue());
        double newDifference = difference = highest - lowest;
        double factor = 1.0;
        if (difference > 24.0) {
            double logBase = 10.0;
            double logScale = Math.floor(Math.log(difference) / Math.log(10.0));
            factor = Math.pow(10.0, logScale);
            newDifference = difference / factor;
            if (newDifference < 8.0) {
                newDifference = difference / (factor /= 10.0);
            }
            boolean success = false;
            int tenFactor = 0;
            do {
                for (double element : FACTORS) {
                    double newfactor = factor * element * Math.pow(10.0, tenFactor);
                    newDifference = difference / newfactor;
                    if (!(newDifference <= 24.0)) continue;
                    factor = newfactor;
                    success = true;
                    break;
                }
                ++tenFactor;
            } while (!success);
        }
        int categoryNumber = (int)Math.round(newDifference);
        Number[] resultArray = new Number[categoryNumber + 1];
        int direction = start.doubleValue() < end.doubleValue() ? 1 : -1;
        for (int i = 0; i < categoryNumber + 1; ++i) {
            resultArray[i] = start.doubleValue() + (double)(i * direction) * factor;
        }
        return resultArray;
    }

    public static Number[] getOptimalRangeAround(Number midPoint, double percentile, int precision, double rangeWidth, Double lowerLimit) {
        if (percentile < 0.0 || percentile > 100.0) {
            throw new IllegalArgumentException("Percentile must be value between 0 and 100.");
        }
        double lowerPart = percentile * 24.0 * Math.pow(10.0, precision) / 100.0;
        double upperPart = (100.0 - percentile) * 24.0 * Math.pow(10.0, precision) / 100.0;
        if (rangeWidth < 0.0 || rangeWidth > 1.0) {
            throw new IllegalArgumentException("Rangewidth must be value between 0 and 1.");
        }
        lowerPart = rangeWidth * lowerPart;
        upperPart = rangeWidth * upperPart;
        if (midPoint instanceof Integer) {
            Double start = (double)Math.round((midPoint.doubleValue() - lowerPart) / Math.pow(10.0, precision)) * Math.pow(10.0, precision);
            Double end = (double)Math.round((midPoint.doubleValue() + upperPart) / Math.pow(10.0, precision)) * Math.pow(10.0, precision);
            double step = Math.pow(10.0, precision);
            ArrayList<Double> result = new ArrayList<Double>();
            for (double next = ((Number)start).doubleValue(); next < end; next += step) {
                if (lowerLimit != null && !(next >= lowerLimit)) continue;
                result.add(next);
            }
            Number[] resultArray = new Number[result.size()];
            return result.toArray(resultArray);
        }
        return GraphHelper.getAxisCategories(midPoint.doubleValue() - lowerPart, midPoint.doubleValue() + upperPart);
    }
}

