/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.statistics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nl.strohalm.cyclos.utils.Pair;

public final class ListOperations {
    public static List<Number> arrayToList(double[] data) {
        ArrayList<Number> list = new ArrayList<Number>();
        for (double element : data) {
            list.add(new Double(element));
        }
        return list;
    }

    public static List<Double> convertToDoubleList(List<Number> list) {
        ArrayList<Double> result = new ArrayList<Double>();
        ListIterator<Number> it = list.listIterator();
        while (it.hasNext()) {
            result.add(it.next().doubleValue());
        }
        return result;
    }

    public static double getElementFromIndex(List<Number> list, double index) {
        double endValue;
        int lowerIndex = (int)Math.floor(index);
        int upperIndex = (int)Math.ceil(index);
        if (upperIndex > list.size() - 1) {
            upperIndex = list.size() - 1;
        }
        if (lowerIndex == upperIndex) {
            endValue = ListOperations.getBalancedValue(list, lowerIndex);
        } else {
            double lowerValue = ListOperations.getBalancedValue(list, lowerIndex);
            double upperValue = ListOperations.getBalancedValue(list, upperIndex);
            endValue = lowerValue + (upperValue - lowerValue) * (index - (double)lowerIndex);
        }
        return endValue;
    }

    public static Number getMax(List<Number> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        Iterator<Number> it = list.iterator();
        double max = it.next().doubleValue();
        while (it.hasNext()) {
            double next = it.next().doubleValue();
            if (!(max < next)) continue;
            max = next;
        }
        return max;
    }

    public static <S, T> List<T> getSecondFromPairCollection(Collection<Pair<S, T>> collection) {
        ArrayList<T> seconds = new ArrayList<T>();
        for (Pair<S, T> pair : collection) {
            T t = pair.getSecond();
            seconds.add(t);
        }
        return seconds;
    }

    public static <S, T extends Number> List<Number> getSecondNumberFromPairCollection(Collection<Pair<S, T>> collection) {
        ArrayList<Number> seconds = new ArrayList<Number>();
        for (Pair<S, T> pair : collection) {
            Number t = (Number)pair.getSecond();
            seconds.add(t);
        }
        return seconds;
    }

    public static double[] listToArray(List<Number> list) {
        double[] array = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).doubleValue();
        }
        return array;
    }

    public static int[] listToIntArray(List<Number> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).intValue();
        }
        return array;
    }

    public static <T> T[][] transposeMatrix(T[][] matrix) {
        if (matrix == null) {
            return null;
        }
        if (matrix.length == 0) {
            return null;
        }
        int rows = matrix.length;
        int cols = matrix[0].length;
        Object[][] result = (Object[][])Array.newInstance(matrix.getClass().getComponentType(), cols);
        for (int j = 0; j < cols; ++j) {
            Object[] secondLevelArray = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), rows);
            result[j] = secondLevelArray;
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                result[j][i] = matrix[i][j];
            }
        }
        return result;
    }

    private static double getBalancedValue(List<Number> list, int index) {
        Number nominalValue = list.get(index);
        double result = nominalValue.doubleValue();
        if (nominalValue.getClass() == Integer.class) {
            int firstItemWithValue = list.indexOf(nominalValue);
            int numberOfItemsWithValue = list.lastIndexOf(nominalValue) + 1 - firstItemWithValue;
            if (numberOfItemsWithValue > 1) {
                double correction = (0.5 + (double)index - (double)firstItemWithValue) / (double)numberOfItemsWithValue;
                result = result - 0.5 + correction;
            }
        }
        return result;
    }
}

