/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.statistics;

import JSci.maths.statistics.NormalDistribution;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.utils.statistics.ListOperations;

public class Median {
    private static final double CONFIDENCE_SYMMETRY_LIMIT = 0.05;
    private final List<Number> list;
    private double alpha;
    private Double median;
    private Double upper = null;
    private Double lower = null;

    public static double getMedian(double[] data) {
        return Median.getMedian(ListOperations.arrayToList(data));
    }

    public static StatisticalNumber getMedian(double[] data, double alpha) {
        return Median.getMedian(ListOperations.arrayToList(data), alpha);
    }

    public static double getMedian(List<Number> l) {
        if (l.size() == 1) {
            return l.get(0).doubleValue();
        }
        Median median = new Median(l);
        return median.getMedian();
    }

    public static StatisticalNumber getMedian(List<Number> l, double alpha) {
        if (l.size() < 15 || l.size() == 0) {
            return new StatisticalNumber();
        }
        if (l.size() == 1) {
            return new StatisticalNumber(l.get(0).doubleValue(), 2);
        }
        Median median = new Median(l, alpha);
        if (median.getHalfOfConfidenceInterval() == null) {
            return new StatisticalNumber(median.getMedian(), median.getLowerLimitConfidenceInterval(), median.getUpperLimitConfidenceInterval(), 2);
        }
        return new StatisticalNumber(median.getMedian(), median.getHalfOfConfidenceInterval(), 2);
    }

    public Median(double[] d) {
        this(ListOperations.arrayToList(d));
    }

    public Median(double[] d, double alpha) {
        this(ListOperations.arrayToList(d));
        this.alpha = alpha;
    }

    public Median(List<Number> list) {
        Collections.sort(list, new Comparator<Number>(){

            @Override
            public int compare(Number a, Number b) {
                if (a.equals(b)) {
                    return 0;
                }
                return a.doubleValue() < b.doubleValue() ? -1 : 1;
            }
        });
        this.list = list;
    }

    public Median(List<Number> list, double alpha) {
        this(list);
        this.alpha = alpha;
    }

    public Double getHalfOfConfidenceInterval() {
        double halfWidth;
        double upperHalfWidth;
        double lowerHalfWidth;
        double asymmetricality;
        if (this.list.size() < 15) {
            return null;
        }
        if (this.median == null) {
            this.getMedian();
        }
        if (this.lower == null) {
            this.calculateConfidenceInterval();
        }
        if ((asymmetricality = Math.abs(((lowerHalfWidth = this.median - this.lower) - (upperHalfWidth = this.upper - this.median)) / (halfWidth = (lowerHalfWidth + upperHalfWidth) / 2.0))) < 0.05) {
            return new Double(halfWidth);
        }
        return null;
    }

    public double getLowerLimitConfidenceInterval() {
        if (this.list.size() < 15) {
            return this.getMedian();
        }
        if (this.lower == null) {
            this.calculateConfidenceInterval();
        }
        return this.lower;
    }

    public double getMedian() {
        double center = ((double)this.list.size() - 1.0) / 2.0;
        this.median = ListOperations.getElementFromIndex(this.list, center);
        return this.median;
    }

    public double getUpperLimitConfidenceInterval() {
        if (this.list.size() < 15) {
            return this.getMedian();
        }
        if (this.upper == null) {
            this.calculateConfidenceInterval();
        }
        return this.upper;
    }

    private void calculateConfidenceInterval() {
        if (this.alpha <= 0.0) {
            throw new NullPointerException("Trying to calculate a confidence interval without setting alpha. Use the other constructor of Median.");
        }
        int n = this.list.size();
        double zAlpha = new NormalDistribution().inverse(1.0 - this.alpha / 2.0);
        double halfWidth = zAlpha * Math.sqrt(n);
        double lowerIndex = (double)(n + 1) / 2.0 - halfWidth - 1.0;
        double upperIndex = (double)(n + 1) / 2.0 + halfWidth - 1.0;
        if (lowerIndex < 0.0) {
            lowerIndex = 0.0;
        }
        if (upperIndex >= (double)this.list.size()) {
            upperIndex = this.list.size() - 1;
        }
        this.lower = new Double(ListOperations.getElementFromIndex(this.list, lowerIndex));
        this.upper = new Double(ListOperations.getElementFromIndex(this.list, upperIndex));
    }
}

