/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.tasks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.scheduling.tasks.ScheduledTask;
import nl.strohalm.cyclos.utils.HazelcastHelper;
import nl.strohalm.cyclos.utils.tasks.TaskRunnerImpl;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextAware;

public class HazelcastTaskRunner
extends TaskRunnerImpl
implements InitializingBean,
ApplicationContextAware {
    private Map<String, String> initializationControl;
    private Map<String, Calendar> scheduledTaskControl;
    private HazelcastInstance hazelcastInstance;

    public void afterPropertiesSet() throws Exception {
        this.hazelcastInstance = HazelcastHelper.getHazelcastInstance(this.applicationContext);
        this.initializationControl = this.hazelcastInstance.getMap("cyclos.initializationControl");
        this.scheduledTaskControl = this.hazelcastInstance.getMap("cyclos.scheduledTaskControl");
    }

    @Override
    public void runInitializations(Collection<String> beanNames) {
        boolean firstTime = true;
        while (!this.allInitializationsExecuted(beanNames)) {
            if (!firstTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            super.runInitializations(beanNames);
            firstTime = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandleDatabaseInitialization(Runnable runnable) {
        LockKey lockKey = new LockKey(KeyType.DB_INIT, "");
        ILock lock = this.hazelcastInstance.getLock((Object)lockKey);
        lock.lock();
        try {
            super.doHandleDatabaseInitialization(runnable);
        }
        finally {
            HazelcastHelper.release(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunInitialization(String beanName) {
        LockKey lockKey = new LockKey(KeyType.INITIALIZATION, beanName);
        ILock lock = this.hazelcastInstance.getLock((Object)lockKey);
        if (lock.tryLock()) {
            if (!this.initializationControl.containsKey(beanName)) {
                try {
                    super.doRunInitialization(beanName);
                    this.initializationControl.put(beanName, beanName);
                }
                finally {
                    HazelcastHelper.release(lock);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not running initialization for bean " + beanName + " because some other node is currently running it"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRunPollingTask(String key, Callable<Boolean> task) {
        LockKey lockKey = new LockKey(KeyType.POLLING_TASK, key);
        ILock lock = this.hazelcastInstance.getLock((Object)lockKey);
        if (lock.tryLock()) {
            try {
                boolean bl = super.doRunPollingTask(key, task);
                return bl;
            }
            finally {
                HazelcastHelper.release(lock);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Some other cluster node is running the " + key + " polling task. Leaving."));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunScheduledTask(String taskName, Calendar time) {
        LockKey lockKey = new LockKey(KeyType.SCHEDULED_TASK, taskName);
        ILock lock = this.hazelcastInstance.getLock((Object)lockKey);
        if (lock.tryLock()) {
            try {
                ScheduledTask scheduledTask = this.getSchedulingHandler().getTask(taskName);
                boolean daily = !scheduledTask.isEveryHour();
                int field = daily ? 5 : 11;
                Calendar lastRun = this.scheduledTaskControl.get(taskName);
                if (lastRun != null) {
                    lastRun = DateUtils.truncate((Calendar)lastRun, (int)field);
                }
                Calendar thisRun = DateUtils.truncate((Calendar)time, (int)field);
                while (lastRun == null || lastRun.before(thisRun)) {
                    if (lastRun == null) {
                        lastRun = thisRun;
                    } else {
                        lastRun.add(field, 1);
                    }
                    super.doRunScheduledTask(taskName, lastRun);
                    this.scheduledTaskControl.put(taskName, lastRun);
                }
            }
            finally {
                HazelcastHelper.release(lock);
            }
        }
    }

    private boolean allInitializationsExecuted(Collection<String> beanNames) {
        for (String beanName : beanNames) {
            if (this.initializationControl.containsKey(beanName)) continue;
            return false;
        }
        return true;
    }

    public static class LockKey
    implements Serializable {
        private static final long serialVersionUID = 3480718144050023229L;
        private final KeyType type;
        private final String name;

        private LockKey(KeyType type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LockKey)) {
                return false;
            }
            LockKey key = (LockKey)obj;
            return key.type == key.type && this.name.equals(key.name);
        }

        public int hashCode() {
            return 13 * this.type.hashCode() * this.name.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.name;
        }
    }

    public static enum KeyType {
        INITIALIZATION,
        SCHEDULED_TASK,
        POLLING_TASK,
        DB_INIT;

    }
}

