/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.tasks;

import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import nl.strohalm.cyclos.scheduling.SchedulingHandler;
import nl.strohalm.cyclos.scheduling.tasks.ScheduledTask;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.ParallelTask;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class TaskRunnerImpl
implements TaskRunner,
ApplicationContextAware {
    protected static final Log LOG = LogFactory.getLog(TaskRunnerImpl.class);
    protected ApplicationContext applicationContext;
    private TransactionHelper transactionHelper;
    private SchedulingHandler schedulingHandler;

    @Override
    public void handleDatabaseInitialization(Runnable runnable) {
        this.doHandleDatabaseInitialization(runnable);
    }

    @Override
    public void runInitializations(Collection<String> beanNames) {
        InitializationThreads threads = new InitializationThreads();
        threads.run(beanNames);
    }

    @Override
    public boolean runPollingTask(String key, Callable<Boolean> task) {
        return this.doRunPollingTask(key, task);
    }

    @Override
    public void runScheduledTasks(Calendar time, Collection<String> taskNames) {
        ScheduledTaskThreads threads = new ScheduledTaskThreads(time);
        threads.run(taskNames);
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void doHandleDatabaseInitialization(Runnable runnable) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Handling database initialization");
            }
            runnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void doRunInitialization(final String beanName) {
        final InitializingService service = (InitializingService)this.applicationContext.getBean(beanName, InitializingService.class);
        this.getTransactionHelper().runInCurrentThread(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Running initialization for bean " + beanName));
                    }
                    LoggedUser.runAsSystem(Executors.callable(new Runnable(){

                        @Override
                        public void run() {
                            service.initializeService();
                        }
                    }));
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Error running initialization for bean " + beanName), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    protected boolean doRunPollingTask(final String key, final Callable<Boolean> task) {
        return this.getTransactionHelper().runInCurrentThread(new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Running polling task " + key));
                    }
                    return (Boolean)LoggedUser.runAsSystem(task);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Error running polling task" + key), (Throwable)e);
                    return false;
                }
            }
        });
    }

    protected void doRunScheduledTask(String taskName, final Calendar time) {
        final ScheduledTask task = this.getSchedulingHandler().getTask(taskName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running scheduled task " + taskName + " with base time " + FormatObject.formatObject(time)));
        }
        if (task.shouldRunInTransaction()) {
            this.getTransactionHelper().runInCurrentThread(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    if (!TaskRunnerImpl.this.doRunScheduledTask(task, time)) {
                        status.setRollbackOnly();
                    }
                }
            });
        } else {
            this.doRunScheduledTask(task, time);
        }
    }

    protected SchedulingHandler getSchedulingHandler() {
        if (this.schedulingHandler == null) {
            this.schedulingHandler = (SchedulingHandler)this.applicationContext.getBean("schedulingHandler", SchedulingHandler.class);
        }
        return this.schedulingHandler;
    }

    protected TransactionHelper getTransactionHelper() {
        if (this.transactionHelper == null) {
            this.transactionHelper = (TransactionHelper)this.applicationContext.getBean("transactionHelper", TransactionHelper.class);
        }
        return this.transactionHelper;
    }

    private boolean doRunScheduledTask(final ScheduledTask task, final Calendar time) {
        try {
            LoggedUser.runAsSystem(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    task.run(time);
                }
            }));
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("Error running scheduled task " + task.getName()), (Throwable)e);
            return false;
        }
    }

    private class ScheduledTaskThreads
    extends ParallelTask<String> {
        private final Calendar time;

        public ScheduledTaskThreads(Calendar time) {
            super("Scheduled tasks for " + FormatObject.formatObject(time));
            this.time = time;
        }

        @Override
        protected void process(String scheduledTask) {
            TaskRunnerImpl.this.doRunScheduledTask(scheduledTask, this.time);
        }
    }

    private class InitializationThreads
    extends ParallelTask<String> {
        public InitializationThreads() {
            super("Initialization");
        }

        @Override
        protected void process(String initialization) {
            TaskRunnerImpl.this.doRunInitialization(initialization);
        }
    }
}

