/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.transaction;

import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import nl.strohalm.cyclos.utils.transaction.TransactionListeners;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;

public class CurrentTransactionData {
    private static ThreadLocal<Entry> HOLDER = new ThreadLocal();

    public static void addTransactionCommitListener(TransactionCommitListener listener) {
        CurrentTransactionData.ensureListeners().addCommitListener(listener);
    }

    public static void addTransactionEndListener(TransactionEndListener listener) {
        CurrentTransactionData.ensureListeners().addEndListener(listener);
    }

    public static void addTransactionRollbackListener(TransactionRollbackListener listener) {
        CurrentTransactionData.ensureListeners().addRollbackListener(listener);
    }

    public static void cleanup() {
        try {
            HOLDER.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearError() {
        Entry entry = CurrentTransactionData.getEntry();
        if (entry != null) {
            entry.error = null;
        }
    }

    public static TransactionListeners detachListeners() {
        TransactionListeners transactionListeners;
        Entry entry = CurrentTransactionData.getEntry();
        TransactionListeners transactionListeners2 = transactionListeners = entry == null ? null : entry.getTransactionListeners();
        if (transactionListeners == null) {
            return TransactionListeners.EMPTY;
        }
        entry.transactionListeners = null;
        return transactionListeners;
    }

    public static Entry getEntry() {
        return HOLDER.get();
    }

    public static Throwable getError() {
        Entry entry = CurrentTransactionData.getEntry();
        return entry == null ? null : entry.error;
    }

    public static MailSendingException getMailError() {
        Entry entry = CurrentTransactionData.getEntry();
        return entry == null ? null : entry.mailError;
    }

    public static boolean hasError() {
        return CurrentTransactionData.getError() != null;
    }

    public static boolean hasMailError() {
        return CurrentTransactionData.getMailError() != null;
    }

    public static boolean hasWrite() {
        Entry entry = CurrentTransactionData.getEntry();
        return entry != null && entry.write;
    }

    public static void setError(Throwable throwable) {
        Entry entry = CurrentTransactionData.ensureEntry();
        if (entry.error == null) {
            entry.error = throwable;
        }
    }

    public static void setMailError(MailSendingException error) {
        CurrentTransactionData.ensureEntry().mailError = error;
    }

    public static void setWrite() {
        CurrentTransactionData.ensureEntry().write = true;
    }

    private static Entry ensureEntry() {
        Entry entry = CurrentTransactionData.getEntry();
        if (entry == null) {
            entry = new Entry();
            HOLDER.set(entry);
        }
        return entry;
    }

    private static TransactionListeners ensureListeners() {
        Entry entry = CurrentTransactionData.ensureEntry();
        TransactionListeners transactionListeners = entry.getTransactionListeners();
        if (transactionListeners == null) {
            transactionListeners = entry.transactionListeners = new TransactionListeners();
        }
        return transactionListeners;
    }

    public static class Entry {
        private Throwable error;
        private MailSendingException mailError;
        private boolean write;
        private TransactionListeners transactionListeners;

        public Throwable getError() {
            return this.error;
        }

        public MailSendingException getMailError() {
            return this.mailError;
        }

        public TransactionListeners getTransactionListeners() {
            return this.transactionListeners;
        }

        public boolean isWrite() {
            return this.write;
        }
    }
}

