/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.transaction;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionListeners {
    private static final Log LOG = LogFactory.getLog(TransactionListeners.class);
    public static final TransactionListeners EMPTY = new TransactionListeners(){

        @Override
        public void addCommitListener(TransactionCommitListener listener) {
        }

        @Override
        public void addEndListener(TransactionEndListener listener) {
        }

        @Override
        public void addRollbackListener(TransactionRollbackListener listener) {
        }
    };
    private List<TransactionCommitListener> commitListeners;
    private List<TransactionRollbackListener> rollbackListeners;

    public void addCommitListener(TransactionCommitListener listener) {
        if (this.commitListeners == null) {
            this.commitListeners = new ArrayList<TransactionCommitListener>();
        }
        this.commitListeners.add(listener);
    }

    public void addEndListener(TransactionEndListener listener) {
        this.addCommitListener(listener);
        this.addRollbackListener(listener);
    }

    public void addRollbackListener(TransactionRollbackListener listener) {
        if (this.rollbackListeners == null) {
            this.rollbackListeners = new ArrayList<TransactionRollbackListener>();
        }
        this.rollbackListeners.add(listener);
    }

    public void runListeners(boolean commit) {
        if (commit) {
            this.runCommitListeners();
        } else {
            this.runRollbackListeners();
        }
    }

    public void runCommitListeners() {
        if (CollectionUtils.isEmpty(this.commitListeners)) {
            return;
        }
        for (TransactionCommitListener listener : this.commitListeners) {
            try {
                listener.onTransactionCommit();
            }
            catch (Exception e) {
                LOG.warn((Object)("Error running transaction commit listener " + listener), (Throwable)e);
            }
        }
    }

    public void runRollbackListeners() {
        if (CollectionUtils.isEmpty(this.rollbackListeners)) {
            return;
        }
        for (TransactionRollbackListener listener : this.rollbackListeners) {
            try {
                listener.onTransactionRollback();
            }
            catch (Exception e) {
                LOG.warn((Object)("Error running transaction rollback listener " + listener), (Throwable)e);
            }
        }
    }
}

