/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public abstract class AbstractPositiveValidation
implements PropertyValidation {
    private static final long serialVersionUID = 3795627794725132006L;
    protected final float test;

    protected AbstractPositiveValidation(boolean includeZero) {
        this.test = includeZero ? 0.0f : 1.0E-4f;
    }

    @Override
    public ValidationError validate(Object object, Object name, Object value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        Number number = null;
        if (value instanceof Number) {
            number = (Number)value;
        } else if (value instanceof Amount) {
            number = ((Amount)value).getValue();
        }
        if (number != null && number.floatValue() < this.test) {
            return new InvalidError();
        }
        return null;
    }
}

