/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.Arrays;
import java.util.Collection;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractValueValidation
implements PropertyValidation {
    private static final long serialVersionUID = 6129247646968815793L;
    private final Collection<?> values;

    protected AbstractValueValidation(Object ... values) {
        this.values = Arrays.asList(values);
    }

    @Override
    public ValidationError validate(Object object, Object name, Object value) {
        if (value != null && !"".equals(value)) {
            boolean contains;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return null;
                }
                contains = CollectionUtils.containsAny(this.values, (Collection)collection);
            } else {
                contains = this.values.contains(value);
            }
            if (contains != this.expected()) {
                return new InvalidError();
            }
        }
        return null;
    }

    protected abstract boolean expected();
}

