/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.lang.StringUtils;

public class CardFormatValidation
implements PropertyValidation {
    private static final int MIN_CARD_DIGITS = 4;
    private static final String ALLOWED_BOUNDARY_CHARS = "#0123456789";
    private static final String ALLOWED_CHARS = "#0123456789 .\\/-_";
    private static final long serialVersionUID = 8420105883132278906L;
    private static final CardFormatValidation INSTANCE = new CardFormatValidation();

    public static CardFormatValidation instance() {
        return INSTANCE;
    }

    @Override
    public ValidationError validate(Object object, Object property, Object value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        String format = (String)value;
        boolean valid = StringUtils.containsOnly((String)format, (String)ALLOWED_CHARS);
        if (valid) {
            boolean bl = valid = ALLOWED_BOUNDARY_CHARS.indexOf(format.charAt(0)) >= 0 && ALLOWED_BOUNDARY_CHARS.indexOf(format.charAt(format.length() - 1)) >= 0;
        }
        if (valid) {
            int cardDigits = 0;
            boolean wasSeparator = false;
            for (int i = 0; i < format.length(); ++i) {
                char c = format.charAt(i);
                if (ALLOWED_BOUNDARY_CHARS.indexOf(c) >= 0) {
                    ++cardDigits;
                    wasSeparator = false;
                    continue;
                }
                if (wasSeparator) {
                    valid = false;
                    break;
                }
                wasSeparator = true;
            }
            if (valid) {
                boolean bl = valid = cardDigits >= 4;
            }
        }
        if (valid) {
            return null;
        }
        return new InvalidError();
    }
}

