/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public class CompareToValidation
implements PropertyValidation {
    private static final long serialVersionUID = 6393982502703438094L;
    private final Comparable<?> comparable;
    private final boolean acceptLess;
    private final boolean acceptEqual;
    private final boolean acceptGreater;
    private ValidationError error;

    public static CompareToValidation greaterEquals(Comparable<?> comparable) {
        return new CompareToValidation(comparable, false, true, true, new ValidationError("errors.greaterEquals", comparable));
    }

    public static CompareToValidation greaterThan(Comparable<?> comparable) {
        return new CompareToValidation(comparable, false, false, true, new ValidationError("errors.greaterThan", comparable));
    }

    public static CompareToValidation lessEquals(Comparable<?> comparable) {
        return new CompareToValidation(comparable, true, true, false, new ValidationError("errors.lessEquals", comparable));
    }

    public static CompareToValidation lessThan(Comparable<?> comparable) {
        return new CompareToValidation(comparable, true, false, false, new ValidationError("errors.lessThan", comparable));
    }

    public CompareToValidation(Comparable<?> comparable, boolean acceptLess, boolean acceptEqual, boolean acceptGreater, ValidationError error) {
        this.comparable = comparable;
        this.acceptLess = acceptLess;
        this.acceptEqual = acceptEqual;
        this.acceptGreater = acceptGreater;
        this.error = error == null ? new InvalidError() : error;
    }

    @Override
    public ValidationError validate(Object object, Object name, Object value) {
        if (this.comparable != null && value instanceof Comparable) {
            boolean isError;
            Object theComparable = CoercionHelper.coerce(value.getClass(), this.comparable);
            int result = ((Comparable)value).compareTo(theComparable);
            if (result < 0) {
                isError = !this.acceptLess;
            } else if (result == 0) {
                isError = !this.acceptEqual;
            } else {
                boolean bl = isError = !this.acceptGreater;
            }
            if (isError) {
                return this.error;
            }
        }
        return null;
    }
}

