/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class DelegatingValidator
extends Validator {
    private static final long serialVersionUID = 8455541438826620344L;
    private final DelegateSource source;

    public DelegatingValidator(DelegateSource source) {
        this.source = source;
    }

    public DelegatingValidator(final Validator delegate) {
        this.source = new DelegateSource(){

            @Override
            public Validator getValidator() {
                return delegate;
            }
        };
    }

    @Override
    public void validate(Object object) throws ValidationException {
        this.source.getValidator().validate(object);
    }

    @Override
    protected void appendValidationErrors(ValidationException vex, Object object) {
        this.source.getValidator().appendValidationErrors(vex, object);
    }

    public static interface DelegateSource {
        public Validator getValidator();
    }
}

