/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.regex.Pattern;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public class EmailValidation
implements PropertyValidation {
    private static final long serialVersionUID = 1601992764743773124L;
    private static final Pattern PATTERN = Pattern.compile("[\\w\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\`\\{\\|\\}\\~][\\w\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\`\\{\\|\\}\\~\\.]*@[a-zA-Z0-9\\.-]+\\.[a-zA-Z]{2,4}");
    private static final EmailValidation INSTANCE = new EmailValidation();

    public static EmailValidation instance() {
        return INSTANCE;
    }

    @Override
    public ValidationError validate(Object object, Object name, Object value) {
        boolean valid;
        if (value == null || "".equals(value)) {
            return null;
        }
        String email = (String)value;
        boolean bl = valid = PATTERN.matcher(email).matches() && !email.contains("..") && !email.contains(".@");
        if (valid) {
            return null;
        }
        return new InvalidError();
    }
}

