/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;

public class InstanceOfValidation
implements PropertyValidation {
    private static final long serialVersionUID = 953633627172013154L;
    private final Class<?> expectedType;

    public InstanceOfValidation(Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public ValidationError validate(Object object, Object property, Object value) {
        String className = (String)value;
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> type = Class.forName(className);
            if (!this.expectedType.isAssignableFrom(type)) {
                throw new Exception();
            }
            Object instance = type.newInstance();
            if (instance instanceof DisposableBean) {
                try {
                    ((DisposableBean)instance).destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception e) {
            return new ValidationError("errors.javaClass", this.expectedType.getName());
        }
    }
}

