/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public class LengthValidation
implements PropertyValidation {
    private static final long serialVersionUID = 6393982502703438094L;
    private final RangeConstraint constraint;

    public LengthValidation(RangeConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public ValidationError validate(Object object, Object name, Object value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        int length = 0;
        if (value instanceof String) {
            length = ((String)value).length();
        } else if (value instanceof Collection) {
            length = ((Collection)value).size();
        } else if (value instanceof Map) {
            length = ((Map)value).size();
        } else if (value.getClass().isArray()) {
            length = ((Object[])value).length;
        }
        return this.constraint.errorFor(length);
    }
}

