/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.Calendar;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public class PeriodValidation
implements PropertyValidation {
    private static final long serialVersionUID = -1732442287413297951L;
    private ValidationType validationType;

    public PeriodValidation(ValidationType validation) {
        this.validationType = validation;
    }

    @Override
    public ValidationError validate(Object object, Object property, Object value) {
        Period period = (Period)value;
        if (period == null) {
            return new RequiredError(new Object[0]);
        }
        if (this.isBeginRequired(this.validationType) && period.getBegin() == null) {
            return new ValidationError("errors.periodBeginRequired", property);
        }
        if (this.isEndRequired(this.validationType) && period.getEnd() == null) {
            return new ValidationError("errors.periodEndRequired", property);
        }
        if (ValidationType.BOTH_REQUIRED == this.validationType || ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED == this.validationType) {
            if (period.getBegin().after(period.getEnd())) {
                return new ValidationError("errors.periodInvalidBounds", property);
            }
            if (ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED == this.validationType && this.hasExpired(period)) {
                return new ValidationError("errors.periodExpired", property);
            }
            return null;
        }
        if (this.validationType == ValidationType.VALIDATE_RANGE) {
            if (period.getBegin() != null && period.getEnd() != null && period.getBegin().after(period.getEnd())) {
                return new ValidationError("errors.periodInvalidBounds", property);
            }
            if (period.getEnd() != null && this.hasExpired(period)) {
                return new ValidationError("errors.periodExpired", property);
            }
            return null;
        }
        return null;
    }

    private boolean hasExpired(Period period) {
        Calendar currentDate = DateHelper.truncate(Calendar.getInstance());
        return DateHelper.truncate(period.getEnd()).before(currentDate);
    }

    private boolean isBeginRequired(ValidationType type) {
        return ValidationType.BEGIN_REQUIRED == type || ValidationType.BOTH_REQUIRED == type || ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED == type;
    }

    private boolean isEndRequired(ValidationType type) {
        return ValidationType.END_REQUIRED == type || ValidationType.BOTH_REQUIRED == type || ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED == type;
    }

    public static enum ValidationType {
        BEGIN_REQUIRED,
        END_REQUIRED,
        BOTH_REQUIRED,
        BOTH_REQUIRED_AND_NOT_EXPIRED,
        VALIDATE_RANGE;

    }
}

