/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.Calendar;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;

public class TodayValidation
implements PropertyValidation {
    private static final long serialVersionUID = -4427502602052617578L;
    private static final TodayValidation PAST = new TodayValidation(true, false, false);
    private static final TodayValidation PAST_OR_TODAY = new TodayValidation(true, true, false);
    private static final TodayValidation FUTURE = new TodayValidation(false, false, true);
    private static final TodayValidation FUTURE_OR_TODAY = new TodayValidation(false, true, true);
    private final boolean allowPast;
    private final boolean allowToday;
    private final boolean allowFuture;

    public static TodayValidation future() {
        return FUTURE;
    }

    public static TodayValidation futureOrToday() {
        return FUTURE_OR_TODAY;
    }

    public static TodayValidation past() {
        return PAST;
    }

    public static TodayValidation pastOrToday() {
        return PAST_OR_TODAY;
    }

    public TodayValidation(boolean allowPast, boolean allowToday, boolean allowFuture) {
        this.allowPast = allowPast;
        this.allowToday = allowToday;
        this.allowFuture = allowFuture;
    }

    @Override
    public ValidationError validate(Object object, Object property, Object value) {
        Calendar calendar = DateHelper.truncate(CoercionHelper.coerce(Calendar.class, value));
        if (calendar == null) {
            return null;
        }
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        int comparision = calendar.compareTo(today);
        if (this.allowPast && comparision < 0 || this.allowToday && comparision == 0 || this.allowFuture && comparision > 0) {
            return null;
        }
        return new InvalidError();
    }
}

