/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.lang.StringUtils;

public class URLValidation
implements PropertyValidation {
    private static final long serialVersionUID = -7933981104151866154L;
    private static final URLValidation INSTANCE_REQUIRING_DOT_ON_HOSTNAME = new URLValidation(true);
    private static final URLValidation INSTANCE = new URLValidation(false);
    private final boolean requireDotOnHostname;

    public static URLValidation instance(boolean requireDotOnHostName) {
        return requireDotOnHostName ? INSTANCE_REQUIRING_DOT_ON_HOSTNAME : INSTANCE;
    }

    private URLValidation(boolean requireDotOnHostname) {
        this.requireDotOnHostname = requireDotOnHostname;
    }

    @Override
    public ValidationError validate(Object object, Object property, Object value) {
        String str = (String)value;
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            URL url;
            String protocol;
            if (!str.contains("://")) {
                str = "http://" + str;
            }
            if (!(protocol = (url = new URL(str)).getProtocol()).equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
                throw new MalformedURLException();
            }
            if (this.requireDotOnHostname && url.getHost().indexOf(46) < 0) {
                throw new MalformedURLException();
            }
            url.toURI();
            return null;
        }
        catch (MalformedURLException e) {
            return new InvalidError();
        }
        catch (URISyntaxException e) {
            return new InvalidError();
        }
    }
}

