/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidationException
extends ApplicationException {
    private static final Log LOG = LogFactory.getLog(ValidationException.class);
    private static final long serialVersionUID = -234845842289514432L;
    private Map<String, String> keysByProperty = new LinkedHashMap<String, String>();
    private Map<String, String> displayNameByProperty = new LinkedHashMap<String, String>();
    private Map<String, Collection<ValidationError>> errorsByProperty = new LinkedHashMap<String, Collection<ValidationError>>();
    private Collection<ValidationError> generalErrors = new LinkedHashSet<ValidationError>();
    private boolean showDetailMessage = false;
    private String baseName;

    public ValidationException() {
    }

    public ValidationException(String key, Object ... args) {
        this(new ValidationError(key, args));
    }

    public ValidationException(String property, String key, ValidationError propertyError) {
        this.addPropertyError(property, propertyError);
        if (key != null) {
            this.setPropertyKey(property, key);
        }
    }

    public ValidationException(String property, ValidationError propertyError) {
        this(property, null, propertyError);
    }

    public ValidationException(ValidationError generalError) {
        this.addGeneralError(generalError);
    }

    public void addGeneralError(ValidationError error) {
        this.generalErrors.add(error);
    }

    public void addPropertyError(String property, ValidationError error) {
        Collection<ValidationError> propertyErrors = this.errorsByProperty.get(property);
        if (propertyErrors == null) {
            propertyErrors = new LinkedHashSet<ValidationError>();
            this.errorsByProperty.put(property, propertyErrors);
        }
        propertyErrors.add(error);
    }

    public Map<String, String> getDisplayNameByProperty() {
        return this.displayNameByProperty;
    }

    public Map<String, Collection<ValidationError>> getErrorsByProperty() {
        return this.errorsByProperty;
    }

    public Collection<ValidationError> getGeneralErrors() {
        return this.generalErrors;
    }

    public Map<String, String> getKeysByProperty() {
        return this.keysByProperty;
    }

    @Override
    public String getMessage() {
        if (this.hasErrors() && this.showDetailMessage) {
            return this.getErrorMessage();
        }
        return null;
    }

    public String getPropertyDisplayName(String property) {
        return this.displayNameByProperty.get(property);
    }

    public String getPropertyKey(String property) {
        return this.keysByProperty.get(property);
    }

    public boolean hasErrors() {
        return !this.generalErrors.isEmpty() || !this.errorsByProperty.isEmpty();
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setDisplayNameByProperty(Map<String, String> displayNameByProperty) {
        this.displayNameByProperty = displayNameByProperty;
    }

    public void setErrorsByProperty(Map<String, Collection<ValidationError>> errorsByProperty) {
        this.errorsByProperty = errorsByProperty;
    }

    public void setGeneralErrors(Collection<ValidationError> generalErrors) {
        this.generalErrors = generalErrors;
    }

    public void setKeysByProperty(Map<String, String> keysByProperty) {
        this.keysByProperty = keysByProperty;
    }

    public void setPropertyDisplayName(String property, String displayName) {
        this.displayNameByProperty.put(property, displayName);
    }

    public void setPropertyKey(String property, String key) {
        this.keysByProperty.put(property, key);
    }

    public void setShowDetailMessage(boolean showDetailMessage) {
        this.showDetailMessage = showDetailMessage;
    }

    public void throwIfHasErrors() throws ValidationException {
        if (this.hasErrors()) {
            if (LOG.isDebugEnabled()) {
                String error = this.getErrorMessage();
                LOG.debug((Object)error, (Throwable)this);
            }
            throw this;
        }
    }

    private String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.baseName != null) {
            sb.append(String.format("%n%n*** Validation Exception: %s ***%n", this.baseName));
        } else {
            sb.append(String.format("%n%n*** Validation Exception ***%n", new Object[0]));
        }
        for (ValidationError validationError : this.generalErrors) {
            sb.append(String.format("* General error: %s\n", validationError));
        }
        for (Map.Entry entry : this.errorsByProperty.entrySet()) {
            sb.append(String.format("* Property errors for [%s]:\n", entry.getKey()));
            for (ValidationError error : (Collection)entry.getValue()) {
                sb.append(String.format("   * %s\n", error));
            }
        }
        sb.append("******\n\n");
        return sb.toString();
    }
}

