/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.validation.AnyOfValidation;
import nl.strohalm.cyclos.utils.validation.CompareToValidation;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InetAddrValidation;
import nl.strohalm.cyclos.utils.validation.InstanceOfValidation;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.NoneOfValidation;
import nl.strohalm.cyclos.utils.validation.NumericValidation;
import nl.strohalm.cyclos.utils.validation.PositiveNonZeroValidation;
import nl.strohalm.cyclos.utils.validation.PositiveValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RegexValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.TodayValidation;
import nl.strohalm.cyclos.utils.validation.URLValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class Validator
implements Serializable {
    private static final long serialVersionUID = -2281234585616311623L;
    private String baseName;
    private String nestedProperty;
    private final List<GeneralValidation> generalValidations = new LinkedList<GeneralValidation>();
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private final List<Validator> chainedValidators = new LinkedList<Validator>();

    public Validator() {
    }

    public Validator(String baseName) {
        this.baseName = baseName;
    }

    public Validator(String baseName, String nestedProperty) {
        this(baseName);
        this.nestedProperty = nestedProperty;
    }

    public Validator chained(Validator ... validators) {
        if (validators != null && validators.length > 0) {
            this.chainedValidators.addAll(Arrays.asList(validators));
        }
        return this;
    }

    public Validator general(GeneralValidation ... validations) {
        if (validations != null && validations.length > 0) {
            this.generalValidations.addAll(Arrays.asList(validations));
        }
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getNestedProperty() {
        return this.nestedProperty;
    }

    public Property property(String name) {
        return this.property(name, null);
    }

    public Property property(String name, PropertyRetrieveStrategy retrieveStrategy) {
        Property property = this.properties.get(name);
        if (property == null) {
            property = retrieveStrategy == null ? new Property(name) : new Property(name, retrieveStrategy);
            this.properties.put(name, property);
        }
        return property;
    }

    public void validate(Object object) throws ValidationException {
        ValidationException vex = new ValidationException();
        vex.setBaseName(this.baseName);
        this.appendValidationErrors(vex, object);
        for (Validator chained : this.chainedValidators) {
            String chainedProperty = chained.getNestedProperty();
            if (chainedProperty == null) {
                chained.appendValidationErrors(vex, object);
                continue;
            }
            Object toValidate = PropertyHelper.get(object, chainedProperty);
            if (toValidate == null) continue;
            chained.appendValidationErrors(vex, toValidate);
        }
        vex.throwIfHasErrors();
    }

    protected void appendValidationErrors(ValidationException vex, Object object) {
        for (GeneralValidation generalValidation : this.generalValidations) {
            ValidationError error = generalValidation.validate(object);
            if (error == null) continue;
            vex.addGeneralError(error);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String name = (String)entry.getKey();
            Property property = (Property)entry.getValue();
            if (property.getKey() != null) {
                vex.setPropertyKey(name, property.getKey());
            } else if (property.getDisplayName() != null) {
                vex.setPropertyDisplayName(name, property.getDisplayName());
            }
            Object value = property.getRetrieveStrategy().get(object);
            Object propertyData = property.getRetrieveStrategy().description(object, name);
            for (PropertyValidation val : property.getValidations()) {
                ValidationError error = val.validate(object, propertyData, value);
                if (error == null) continue;
                vex.addPropertyError(name, error);
            }
        }
    }

    public static interface PropertyRetrieveStrategy
    extends Serializable {
        public Object description(Object var1, String var2);

        public Object get(Object var1);
    }

    public class Property
    implements Serializable {
        private static final long serialVersionUID = -6974004392652790404L;
        private final String name;
        private String displayName;
        private String key;
        private final List<PropertyValidation> validations = new ArrayList<PropertyValidation>();
        private final PropertyRetrieveStrategy retrieveStrategy;

        private Property(String name) {
            this(name, new BeanPropertyRetrieveStrategy(name));
        }

        private Property(String name, PropertyRetrieveStrategy retrieveStrategy) {
            this.name = name;
            this.retrieveStrategy = retrieveStrategy;
            if (StringUtils.isNotEmpty((String)Validator.this.baseName)) {
                this.key(Validator.this.baseName + "." + name);
            }
        }

        public Property add(PropertyValidation ... validations) {
            if (validations != null) {
                for (PropertyValidation validation : validations) {
                    this.validations.add(validation);
                }
            }
            return this;
        }

        public Property anyOf(Collection<?> values) {
            return this.add(new AnyOfValidation(values));
        }

        public Property anyOf(Object ... values) {
            return this.add(new AnyOfValidation(values));
        }

        public Property between(Number from, Number to) {
            return this.between(from, to, true, true);
        }

        public Property between(Number from, Number to, boolean includeLowerBound, boolean includeUpperBound) {
            if (includeLowerBound) {
                this.greaterEquals(from);
            } else {
                this.greaterThan(from);
            }
            if (includeUpperBound) {
                return this.lessEquals(to);
            }
            return this.lessThan(to);
        }

        public Property comparable(Comparable<?> comparable, String operation) {
            return this.comparable(comparable, operation, null);
        }

        public Property comparable(Comparable<?> comparable, String operation, ValidationError error) {
            boolean acceptNegative = Arrays.asList("<", "<=").contains(operation);
            boolean acceptZero = Arrays.asList("<=", "=", ">=").contains(operation);
            boolean acceptPositive = Arrays.asList(">", ">=").contains(operation);
            return this.add(new CompareToValidation(comparable, acceptNegative, acceptZero, acceptPositive, error));
        }

        public Property displayName(String displayName) {
            this.displayName = displayName;
            this.key = null;
            return this;
        }

        public Property fixedLength(int length) {
            return this.length(length, length);
        }

        public Property future() {
            return this.add(TodayValidation.future());
        }

        public Property futureOrToday() {
            return this.add(TodayValidation.futureOrToday());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public PropertyRetrieveStrategy getRetrieveStrategy() {
            return this.retrieveStrategy;
        }

        public List<PropertyValidation> getValidations() {
            return this.validations;
        }

        public Property greaterEquals(Number number) {
            return this.add(CompareToValidation.greaterEquals((Comparable)((Object)number)));
        }

        public Property greaterThan(Number number) {
            return this.add(CompareToValidation.greaterThan((Comparable)((Object)number)));
        }

        public Property inetAddr() {
            return this.add(InetAddrValidation.instance());
        }

        public Property instanceOf(Class<?> expectedType) {
            return this.add(new InstanceOfValidation(expectedType));
        }

        public Property key(String key) {
            this.key = key;
            this.displayName = null;
            return this;
        }

        public Property length(int from, int to) {
            return this.add(new LengthValidation(RangeConstraint.between(from, to)));
        }

        public Property lessEquals(Number number) {
            return this.add(CompareToValidation.lessEquals((Comparable)((Object)number)));
        }

        public Property lessThan(Number number) {
            return this.add(CompareToValidation.lessThan((Comparable)((Object)number)));
        }

        public Property maxLength(int maxLength) {
            return this.add(new LengthValidation(RangeConstraint.to(maxLength)));
        }

        public Property minLength(int minLength) {
            return this.add(new LengthValidation(RangeConstraint.from(minLength)));
        }

        public Property noneOf(Collection<?> values) {
            return this.add(new NoneOfValidation(values));
        }

        public Property noneOf(Object ... values) {
            return this.add(new NoneOfValidation(values));
        }

        public Property numeric() {
            return this.add(NumericValidation.instance());
        }

        public Property past() {
            return this.add(TodayValidation.past());
        }

        public Property pastOrToday() {
            return this.add(TodayValidation.pastOrToday());
        }

        public Property positive() {
            return this.add(PositiveValidation.instance());
        }

        public Property positiveNonZero() {
            return this.add(PositiveNonZeroValidation.instance());
        }

        public Property regex(String regex) {
            return this.add(new RegexValidation(regex));
        }

        public Property required() {
            return this.add(RequiredValidation.instance());
        }

        public Property url() {
            return this.url(false);
        }

        public Property url(boolean requireDotOnHostname) {
            return this.add(URLValidation.instance(requireDotOnHostname));
        }
    }

    public static class BeanPropertyRetrieveStrategy
    implements PropertyRetrieveStrategy {
        private static final long serialVersionUID = -5276405909672992884L;
        private final String name;

        public BeanPropertyRetrieveStrategy(String name) {
            this.name = name;
        }

        @Override
        public Object description(Object object, String name) {
            return name;
        }

        @Override
        public Object get(Object object) {
            return PropertyHelper.get(object, this.name);
        }
    }
}

