/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import nl.strohalm.cyclos.webservices.access.AccessWebService;
import nl.strohalm.cyclos.webservices.accounts.AccountWebService;
import nl.strohalm.cyclos.webservices.ads.AdWebService;
import nl.strohalm.cyclos.webservices.fields.FieldWebService;
import nl.strohalm.cyclos.webservices.infotexts.InfoTextWebService;
import nl.strohalm.cyclos.webservices.members.MemberWebService;
import nl.strohalm.cyclos.webservices.payments.PaymentWebService;
import nl.strohalm.cyclos.webservices.pos.PosWebService;
import nl.strohalm.cyclos.webservices.sms.SmsWebService;
import nl.strohalm.cyclos.webservices.webshop.WebShopWebService;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;

public class CyclosWebServicesClientFactory
implements Serializable {
    private static final long serialVersionUID = 8877667897548825737L;
    private static final Map<Class<?>, String> SERVICES;
    private transient Map<Class<?>, Object> cachedProxies = new HashMap();
    private String serverRootUrl;
    private String username;
    private String password;
    private boolean disableCNCheck;
    private boolean trustAllCerts;
    private long readTimeout = 60000L;
    private long connectionTimeout = 60000L;

    public static Class<?> serviceInterfaceForName(String name) {
        for (Map.Entry<Class<?>, String> entry : SERVICES.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public CyclosWebServicesClientFactory() {
    }

    public CyclosWebServicesClientFactory(String serverRootUrl) {
        this.setServerRootUrl(serverRootUrl);
    }

    public CyclosWebServicesClientFactory(String serverRootUrl, String username, String password) {
        this(serverRootUrl);
        this.setUsername(username);
        this.setPassword(password);
    }

    public AccessWebService getAccessWebService() {
        return this.proxyFor(AccessWebService.class);
    }

    public AccountWebService getAccountWebService() {
        return this.proxyFor(AccountWebService.class);
    }

    public AdWebService getAdWebService() {
        return this.proxyFor(AdWebService.class);
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public FieldWebService getFieldWebService() {
        return this.proxyFor(FieldWebService.class);
    }

    public InfoTextWebService getInfoTextWebService() {
        return this.proxyFor(InfoTextWebService.class);
    }

    public MemberWebService getMemberWebService() {
        return this.proxyFor(MemberWebService.class);
    }

    public PaymentWebService getPaymentWebService() {
        return this.proxyFor(PaymentWebService.class);
    }

    public PosWebService getPosWebService() {
        return this.proxyFor(PosWebService.class);
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public SmsWebService getSmsWebService() {
        return this.proxyFor(SmsWebService.class);
    }

    public WebShopWebService getWebShopWebService() {
        return this.proxyFor(WebShopWebService.class);
    }

    public synchronized <T> T proxyFor(Class<T> serviceInterface) {
        Object cached = this.cachedProxies.get(serviceInterface);
        if (cached != null) {
            return (T)cached;
        }
        String url = this.resolveUrlFor(serviceInterface);
        if (url == null) {
            throw new IllegalStateException("Cannot resolve url for service " + serviceInterface.getName() + " for server root url " + this.serverRootUrl);
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(serviceInterface);
        factory.setAddress(url);
        Object proxy = factory.create();
        Client client = ClientProxy.getClient((Object)proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        if (this.username != null || this.password != null) {
            AuthorizationPolicy authorization = new AuthorizationPolicy();
            authorization.setUserName(this.username);
            authorization.setPassword(this.password);
            http.setAuthorization(authorization);
            http.setAuthSupplier((HttpAuthSupplier)new DefaultBasicAuthSupplier());
        }
        http.setTlsClientParameters(this.getTLSClientParameters());
        http.getClient().setConnectionTimeout(this.connectionTimeout);
        http.getClient().setReceiveTimeout(this.readTimeout);
        this.cachedProxies.put(serviceInterface, proxy);
        return (T)proxy;
    }

    public String resolveUrlFor(Class<?> serviceInterface) {
        String service = SERVICES.get(serviceInterface);
        if (this.serverRootUrl == null || service == null) {
            throw new IllegalArgumentException("Unknown web service interface: " + serviceInterface.getName());
        }
        return this.serverRootUrl + "/services/" + service;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setDisableCNCheck(boolean disableCNCheck) {
        this.disableCNCheck = disableCNCheck;
    }

    public void setPassword(String password) {
        this.password = StringUtils.trimToNull((String)password);
        this.invalidateCache();
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setServerRootUrl(String serverRootUrl) {
        this.serverRootUrl = StringUtils.trimToNull((String)serverRootUrl);
        if (this.serverRootUrl != null && this.serverRootUrl.endsWith("/")) {
            this.serverRootUrl = this.serverRootUrl.substring(0, this.serverRootUrl.length() - 1);
        }
        this.invalidateCache();
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setUsername(String username) {
        this.username = StringUtils.trimToNull((String)username);
        this.invalidateCache();
    }

    public void shutdown() {
        for (Object proxy : this.cachedProxies.values()) {
            try {
                Client client = ClientProxy.getClient((Object)proxy);
                client.destroy();
            }
            catch (Exception exception) {}
        }
        this.cachedProxies.clear();
        BusFactory.getDefaultBus().shutdown(true);
    }

    private TLSClientParameters getTLSClientParameters() {
        TLSClientParameters tlsCP = new TLSClientParameters();
        if (this.trustAllCerts) {
            TrustManager[] myTrustStoreKeyManagers = this.getTrustManagers();
            tlsCP.setTrustManagers(myTrustStoreKeyManagers);
        }
        tlsCP.setDisableCNCheck(this.disableCNCheck);
        return tlsCP;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        return trustManagers;
    }

    private void invalidateCache() {
        this.cachedProxies.clear();
    }

    static {
        HashMap<Class, String> services = new HashMap<Class, String>();
        services.put(MemberWebService.class, "members");
        services.put(AdWebService.class, "ads");
        services.put(FieldWebService.class, "fields");
        services.put(WebShopWebService.class, "webshop");
        services.put(AccessWebService.class, "access");
        services.put(AccountWebService.class, "account");
        services.put(PaymentWebService.class, "payment");
        services.put(PosWebService.class, "pos");
        services.put(SmsWebService.class, "sms");
        services.put(InfoTextWebService.class, "infoTexts");
        SERVICES = Collections.unmodifiableMap(services);
    }
}

